<?php $__env->startSection('meta_info'); ?>
    <title><?php echo e(setting('site_title')); ?></title>
    <meta name="description" content="<?php echo e(setting('meta_description')); ?>">
    <meta name="keywords" content="<?php echo e(setting('meta_keywords')); ?>">
    <meta name="author" content="<?php echo e(setting('meta_author')); ?>">
<?php $__env->stopSection(); ?>
<style>


.service-container{
    max-width:1200px;
    margin:auto;
    color:#fff;
}

.service-item{
    display:flex;
    border-bottom:1px solid #222;
    padding:8px 0;
}

.service-number{
    font-size:90px;
    font-weight:800;
    color:#ffb400;
    line-height:0.85; /* extra bottom space remove */
    margin-right:30px;
    letter-spacing:-3px;
}



.service-title{
    font-size:2rem;
    font-weight:700 !important;
    margin-top:2.1rem !important;
}

.service-subtitle{
    font-size:1.5rem !important;
    color:#be9533;
    margin-top:15px;
    display:block;
}

.service-features{
    margin-left:auto;
    list-style:none;
    width:300px;
    padding:0;
    margin-bottom:8px; /* align with number baseline */
}

.service-features li{
    padding:20px 0;
    border-bottom:1px solid #222;
    font-size:1.2rem !important;
    color:#ccc;
}

.service-features li:last-child{
    border-bottom:none;
}

.service-features li::before{
    content:"✓";
    color:#ffb400;
    margin-right:10px;
}
@media screen and (max-width: 500px) {
.service-number{
    font-size:50px;

}
.service-subtitle{
    font-size:1.2rem !important;

}
.service-title{
    font-size:1.5rem;
    margin-top:1.1rem !important;
}

}

@media (min-width: 500px) and (max-width: 768px) {
.service-number{
    font-size:50px;

}
.service-subtitle{
    font-size:1.2rem !important;

}
.service-title{
    font-size:1.5rem;
    margin-top:1.1rem !important;
}
}
</style>

<?php $__env->startSection('content'); ?>
 <div id="service" class="container">
            <div class="mt-4 row">
                <div class="col-md-12"><h1 id="hero-text">Crafting Every<span> Loop</span><br>of Your
                    <span>Brand Story.</span> </h1>
                    
                       <hr>
                     <div class="mt-4"><h4 id="sub_title" style="">“Design is the silent ambassador of your brand.</h1>
                    </div>
                 
                    <p class="qoute"> — Paul Rand</p>
                    
                      <hr>
                    <p id="hero-p" class="mt-5">At Studio Looper, we spin brands into stories people can’t ignore. From bold
                        visuals and killer campaigns to digital magic that makes your brand shine, we’re
                        here to craft work that connects, sells, and sticks. Ready to see what creative trouble
                        we can stir up for you? Let’s loop.</p>
                       <hr>
                       
<div class="service-container">

    <!-- 01 -->
    <div class="service-item">
        <div class="service-number">01</div>
        <div class="service-left">
            <h2 class="service-title">Brand Identity</h2>
            <span class="service-subtitle">Your look should tell your legend.</span>
        </div>
        <ul class="service-features">
            <li>Craft bold, iconic visuals.</li>
            <li>Define your brand voice.</li>
            <li>Shape your story.</li>
        </ul>
    </div>

    <!-- 02 -->
    <div class="service-item">
        <div class="service-number">02</div>
        <div class="service-left">
            <h2 class="service-title">Campaign Concepts</h2>
            <span class="service-subtitle">Ads that can’t be ignored.</span>
        </div>
        <ul class="service-features">
            <li>Create memorable ideas.</li>
            <li>Ignite emotions.</li>
            <li>Drive action.</li>
        </ul>
    </div>

    <!-- 03 -->
    <div class="service-item">
        <div class="service-number">03</div>
        <div class="service-left">
            <h2 class="service-title">Communication Strategy</h2>
            <span class="service-subtitle">Make your message matter.</span>
        </div>
        <ul class="service-features">
            <li>Find the right insight.</li>
            <li>Own the conversation.</li>
            <li>Deliver with impact.</li>
        </ul>
    </div>

    <!-- 04 -->
    <div class="service-item">
        <div class="service-number">04</div>
        <div class="service-left">
            <h2 class="service-title">Social & Content Systems</h2>
            <span class="service-subtitle">Fuel your brand’s presence.</span>
        </div>
        <ul class="service-features">
            <li>Build engaging content.</li>
            <li>Plan with purpose.</li>
            <li>Grow your audience.</li>
        </ul>
    </div>

    <!-- 05 -->
    <div class="service-item">
        <div class="service-number">05</div>
        <div class="service-left">
            <h2 class="service-title">Creative Design</h2>
            <span class="service-subtitle">Ideas, perfectly executed.</span>
        </div>
        <ul class="service-features">
            <li>Elevate the visuals.</li>
            <li>Manage the magic.</li>
            <li>Bring it all to life.</li>
        </ul>
    </div>

</div>
                       
                </div>
            </div>

        </div>
             <div class="container mt-5 mb-5">
            <div class="">
                <div class="col-md-6">
                    <div class="mb-0"><h6 id="hero-h6" class="mb-0">Let’s Talk <a href="./contact-us"><img
                            class="hero-img" style="width:35px;height:35px;" src="<?php echo e(asset('assets/media/Forward Icon_Yellow.a55e1a6f.svg')); ?>" alt=""></a>
                    </h6></div>
                </div>
             
            </div>
        </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/studiol3/dev.studiolooper.com/resources/views/front/pages/services.blade.php ENDPATH**/ ?>