
<?php $__env->startSection('title'); ?>
    Admin | All Slider
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>
<style>
    .slider table img{
        float: none;
        width: 241px !important;
        height: 68px;
        object-fit: cover;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
   
        <div class="slider container-fluid">
            <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">Add Slider</h6>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post" action="<?php echo e(route('slider.store')); ?>"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="title">Title <span class="text-danger"></span></label>
                                    <input class="form-control" name="title" placeholder="Title" type="text"
                                           autocomplete="off" required>
                                    <span class="text-danger"><?php echo e($errors->has('title') ? $errors->first('title'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="caption">Caption <span class="text-danger"></span></label>
                                    <textarea class="form-control" rows="3" name="caption"  placeholder="Caption"></textarea>
                                    <span class="text-danger"><?php echo e($errors->has('caption') ? $errors->first('caption'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="link">Link <span class="text-danger"></span></label>
                                    <input class="form-control" name="link" placeholder="Link" type="text"
                                           autocomplete="off">
                                    <span class="text-danger"><?php echo e($errors->has('link') ? $errors->first('link'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="possition">Position <span class="text-danger"></span></label>
                                    <input class="form-control" id="position" type="number" name="position"
                                           placeholder="Enter position (lower number has high priority)"
                                           min="0">
                                    <span class="text-danger"><?php echo e($errors->has('position') ? $errors->first('position'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="device">Device <span class="text-danger">*</span></label>
                                    <select class="form-control" name="device">
                                        <option value="desktop">desktop</option>
                                        <option value="mobile">mobile</option>
                                    </select>
                                    <span class="text-danger"><?php echo e($errors->has('device') ? $errors->first('device'):''); ?></span>
                                </div>

                                <div class="form-group">
                                     <label for="image">Image<small>(982x500)</small><span
                                                class="text-danger">*</span></label>
                                     <div class="custom-file">
                                        <input type="file" class="custom-file-input profile-img-input"  id="image" name="image">
                                        <label class="custom-file-label" for="customFile">Choose file</label>
                                     </div>
                                     <span class="text-danger"><?php echo e($errors->has('image') ? $errors->first('image'):''); ?></span>
                                     <div class="pt-1" id="profileLabel" for="image">
                                        <img class="profileImgShow" src="<?php echo e(asset('defaults/default3.png')); ?>">
                                     </div>
                                </div>
                                
                                <button type="submit" class="float-right btn btn-primary">Create</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Slider</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Title</th>
                                        <th class="text-center">Device</th>
                                        <th class="text-center">Image</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $slider; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center"><?php echo e($row->position); ?></td>
                                            <td><?php echo e($row->title); ?></td>
                                            <td class="text-center"><?php echo e($row->device); ?></td>
                                            <td class="text-center"><img src="<?php echo e(asset('img/slider/'.$row->image)); ?>">
                                            </td>
                                            <td class="col__action__body">
                                                <a href="<?php echo e(route('slider.edit', ['id' => $row->id])); ?>"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="<?php echo e(route('slider.destroy', ['id' => $row->id])); ?>"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div> <!--col-6-->
            </div>
        </div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/studiol3/dev.studiolooper.com/resources/views/back/slider/slider_index.blade.php ENDPATH**/ ?>