<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdController;
use App\Http\Controllers\SmsController;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\WorkController;
use App\Http\Controllers\DraftController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\PhotoController;
use App\Http\Controllers\PopupController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\DesignController;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\PartnerController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\SubMenuController;
use App\Http\Controllers\UpazilaController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\DistrictController;
use App\Http\Controllers\DivisionController;
use App\Http\Controllers\MagazineController;
use App\Http\Controllers\WorkTypeController;
use App\Http\Controllers\ClientTypeController;
use App\Http\Controllers\Front\HomeController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\PagecategoryController;
use App\Http\Controllers\VideoGalleryController;
use App\Http\Controllers\CompleteWorkController;
use App\Http\Controllers\SystemSettingController;
use App\Http\Controllers\ContactMessageController;
use App\Http\Controllers\GeneralSettingController;
use App\Http\Controllers\ParentCategoryController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::fallback(function () {
    return view('errors.my_404');
});




Route::get('/', [HomeController::class, 'home'])->name('frontend');
Route::get('/completed-work', [HomeController::class, 'completed_work'])->name('completed-work');
Route::get('/services', [HomeController::class, 'services'])->name('services');
Route::get('/package', [HomeController::class, 'package'])->name('package');
Route::get('/order-now', [HomeController::class, 'orderNow'])->name('order_now');
Route::get('/client', [HomeController::class, 'client'])->name('client');
Route::get('/client/{slug}', [HomeController::class, 'client_single'])->name('client.single');
Route::get('/work/{id}/{slug?}', [HomeController::class, 'work_single'])->name('work.single');
Route::get('/{category}/blog/{id}', [HomeController::class, 'singlePost'])->name('single.post');
Route::get('/blogs', [HomeController::class, 'posts'])->name('posts');
Route::get('/about-us', [HomeController::class, 'about'])->name('about');
Route::get('/contact-us', [HomeController::class, 'contact'])->name('contact');
Route::get('/privacy-policy', [HomeController::class, 'privacy'])->name('privacy');
Route::get('/terms-condition', [HomeController::class, 'terms'])->name('terms');
Route::get('/return-policy', [HomeController::class, 'return_policy'])->name('return_policy');
Route::get('/our-plan', [HomeController::class, 'plan'])->name('plan');
Route::post('/message', [HomeController::class, 'message'])->name('message');
Route::get('/our-team', [HomeController::class, 'team'])->name('team');
Route::get('/gallery', [HomeController::class, 'gallery'])->name('gallery');



Route::get('/dashboard', function () {
    return view('back.index');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::group(['prefix' => 'app'], function () {
        //new route open
        //===================== SMS Related Route List ===========================
        Route::prefix('sms')->group(function () {
            Route::get('general-sms/list', [SmsController::class, 'generalSmsList'])->name('general-sms.list');
            Route::get('general-sms/create', [SmsController::class, 'generalSmsCreate'])->name('general-sms.create');
            Route::post('general-sms/send', [SmsController::class, 'generalSmsSend'])->name('general-sms.send');
            //sms report
            Route::get('reports', [SmsController::class, 'smsReports'])->name('sms-reports');
            Route::post('reports/search-sms', [SmsController::class, 'searchSmsData'])->name('sms-reports.search-sms');
        });

   
        //banner
        Route::get('/banner/create', [BannerController::class, 'create'])->name('banner.create');
        Route::post('/banner/store', [BannerController::class, 'store'])->name('banner.store');
        Route::get('/banner/edit/{id}', [BannerController::class, 'edit'])->name('banner.edit');
        Route::post('/banner/update/{id}', [BannerController::class, 'update'])->name('banner.update');
        Route::get('/banner/delete/{id}', [BannerController::class, 'destroy'])->name('banner.delete');
        //menu
        Route::get('/menu/create', [MenuController::class, 'create'])->name('menu.create');
        Route::get('/menu/managers', [MenuController::class, 'index'])->name('menu.index');
        Route::post('/menu/store', [MenuController::class, 'store'])->name('menu.store');
        Route::get('/menu/edit/{id}', [MenuController::class, 'edit'])->name('menu.edit');
        Route::post('/menu/update/{id}', [MenuController::class, 'update'])->name('menu.update');
        Route::get('/menu/delete/{id}', [MenuController::class, 'destroy'])->name('menu.delete');
        //submenu
        Route::get('/submenu/create', [SubMenuController::class, 'create'])->name('submenu.create');
        Route::get('/submenu/managers', [SubMenuController::class, 'index'])->name('submenu.index');
        Route::post('/submenu/store', [SubMenuController::class, 'store'])->name('submenu.store');
        Route::get('/submenu/edit/{id}', [SubMenuController::class, 'edit'])->name('submenu.edit');
        Route::post('/submenu/update/{id}', [SubMenuController::class, 'update'])->name('submenu.update');
        Route::delete('/submenu/delete/{id}', [SubMenuController::class, 'destroy'])->name('submenu.delete');
        //category
        Route::get('/parent/category/create', [ParentCategoryController::class, 'create'])->name('Pcategory.create');
        Route::get('/parent/categories/managers', [ParentCategoryController::class, 'index'])->name('Pcategory.index');
        Route::post('/parent/category/store', [ParentCategoryController::class, 'store'])->name('Pcategory.store');
        Route::get('/parent/category/edit/{id}', [ParentCategoryController::class, 'edit'])->name('Pcategory.edit');
        Route::post('/parent/category/update/{id}', [ParentCategoryController::class, 'update'])->name('Pcategory.update');
        Route::get('/parent/category/delete/{id}', [ParentCategoryController::class, 'destroy'])->name('Pcategory.delete');
        //category
        Route::get('/category/create', [CategoryController::class, 'create'])->name('category.create');
        Route::get('/categories/managers', [CategoryController::class, 'index'])->name('category.index');
        Route::post('/category/store', [CategoryController::class, 'store'])->name('category.store');
        Route::get('/category/edit/{id}', [CategoryController::class, 'edit'])->name('category.edit');
        Route::post('/category/update/{id}', [CategoryController::class, 'update'])->name('category.update');
        Route::get('/category/delete/{id}', [CategoryController::class, 'destroy'])->name('category.delete');
        Route::post('changeHomePage', [CategoryController::class, 'changeHomePage'])->name('changeHomePage');
        //sub_category
        Route::get('/sub/category/create',[SubCategoryController::class, 'create'])->name('sub_category.create');
        Route::get('/sub/categories/managers',[SubCategoryController::class, 'index'])->name('sub_category.index');
        Route::post('/sub/category/store',[SubCategoryController::class, 'store'])->name('sub_category.store');
        Route::get('/sub/category/edit/{id}',[SubCategoryController::class, 'edit'])->name('sub_category.edit');
        Route::post('/sub/category/update/{id}',[SubCategoryController::class, 'update'])->name('sub_category.update');
        Route::delete('/sub/category/destroy/{id}',[SubCategoryController::class, 'destroy'])->name('sub_category.destroy');
        //product
        Route::get('/product/create', [ProductController::class, 'create'])->name('product.create');
        Route::get('/product/manage', [ProductController::class, 'index'])->name('product.index');
        Route::post('/product/store', [ProductController::class, 'store'])->name('product.store');
        Route::get('/product/edit/{id}', [ProductController::class, 'edit'])->name('product.edit');
        Route::post('/product/update/{id}', [ProductController::class, 'update'])->name('product.update');
        Route::get('/product/delete/{id}', [ProductController::class, 'destroy'])->name('product.destroy');
        //member
        Route::get('/member/create', [MemberController::class, 'create'])->name('member.create');
        Route::get('/member/manage', [MemberController::class, 'index'])->name('member.index');
        Route::post('/member/store', [MemberController::class, 'store'])->name('member.store');
        Route::get('/member/edit/{id}', [MemberController::class, 'edit'])->name('member.edit');
        Route::post('/member/update/{id}', [MemberController::class, 'update'])->name('member.update');
        Route::get('/member/delete/{id}', [MemberController::class, 'destroy'])->name('member.destroy');
        //contact message
        Route::get('/message/managers', [ContactMessageController::class,'index'])->name('message.index');
        Route::get('/message/view/{id}', [ContactMessageController::class,'view'])->name('message.view');
        Route::get('/message/destroy/{id}', [ContactMessageController::class,'destroy'])->name('message.destroy');
        //post
        Route::get('post/create', [PostController::class, 'create'])->name('post.create');
        Route::get('post/index', [PostController::class, 'index'])->name('post.index');
        Route::post('post/store', [PostController::class, 'store'])->name('post.store');
        Route::get('post/edit/{id}', [PostController::class, 'edit'])->name('post.edit');
        Route::post('post/update/{id}', [PostController::class, 'update'])->name('post.update');
        Route::get('post/destroy/{id}', [PostController::class, 'destroy'])->name('post.destroy');
        Route::get('post/search', [PostController::class, 'search'])->name('post.search');
        Route::post('post/publication/ststus/change', [PostController::class,'changePublicationStatus'])->name('changePublicationStatus');
        Route::get('/trashpost/index',  [PostController::class, 'trashpost_index'])->name('trashpost.index');
        Route::get('/trashpost/view/{id}',  [PostController::class, 'trashpost_view'])->name('trashpost.view');
        //draft
        Route::get('/draft/managers',  [DraftController::class, 'index'])->name('draft.index');
        Route::get('/draft/edit/{id}',  [DraftController::class, 'edit'])->name('draft.edit');
        Route::post('/draft/draft2post/{id}',  [DraftController::class, 'store'])->name('post.store.draft2post');
        Route::delete('/draft/destroy/{id}',  [DraftController::class, 'destroy'])->name('draft.destroy');
        //design
        Route::get('/design/managers',  [DesignController::class, 'index'])->name('design.index');
        Route::get('/design/create',  [DesignController::class, 'create'])->name('design.create');
        Route::post('/design/store',  [DesignController::class, 'store'])->name('design.store');
        Route::get('/design/edit/{id}',  [DesignController::class, 'edit'])->name('design.edit');
        Route::post('/design/update/{id}',  [DesignController::class, 'update'])->name('design.update');
        Route::delete('/design/destroy/{id}',  [DesignController::class, 'destroy'])->name('design.destroy');

        //photo
        Route::get('/photo/managers',  [PhotoController::class, 'index'])->name('photo.index');
        Route::get('/photo/create',  [PhotoController::class, 'create'])->name('photo.create');
        Route::post('/photo/store',  [PhotoController::class, 'store'])->name('photo.store');
        Route::get('/photo/edit/{id}',  [PhotoController::class, 'edit'])->name('photo.edit');
        Route::post('/photo/update/{id}',  [PhotoController::class, 'update'])->name('photo.update');
        Route::delete('/photo/destroy/{id}',  [PhotoController::class, 'destroy'])->name('photo.destroy');
        //video
        Route::get('/video/managers',  [VideoGalleryController::class, 'index'])->name('video.index');
        Route::get('/video/create',  [VideoGalleryController::class, 'create'])->name('video.create');
        Route::post('/video/store',  [VideoGalleryController::class, 'store'])->name('video.store');
        Route::get('/video/edit/{id}',  [VideoGalleryController::class, 'edit'])->name('video.edit');
        Route::post('/video/update/{id}',  [VideoGalleryController::class, 'update'])->name('video.update');
        Route::delete('/video/destroy/{id}',  [VideoGalleryController::class, 'destroy'])->name('video.destroy');
        //magazine
        Route::get('/magazine/managers',  [MagazineController::class, 'index'])->name('magazine.index');
        Route::get('/magazine/create',  [MagazineController::class, 'create'])->name('magazine.create');
        Route::post('/magazine/store',  [MagazineController::class, 'store'])->name('magazine.store');
        Route::get('/magazine/edit/{id}',  [MagazineController::class, 'edit'])->name('magazine.edit');
        Route::post('/magazine/update/{id}',  [MagazineController::class, 'update'])->name('magazine.update');
        Route::get('/magazine/destroy/{id}',  [MagazineController::class, 'destroy'])->name('magazine.destroy');
        //  popup
        Route::get('/popup/create', [PopupController::class, 'create'])->name('popup.create');
        Route::get('/popup/managers', [PopupController::class, 'index'])->name('popup.index');
        Route::post('/popup/store', [PopupController::class, 'store'])->name('popup.store');
        Route::get('/popup/edit/{id}', [PopupController::class, 'edit'])->name('popup.edit');
        Route::post('/popup/update/{id}', [PopupController::class, 'update'])->name('popup.update');
        Route::get('/popup/destroy/{id}', [PopupController::class, 'destroy'])->name('popup.destroy');
        //division
        Route::get('/division/create', [DivisionController::class, 'create'])->name('division.create');
        Route::get('/division/managers', [DivisionController::class, 'index'])->name('division.index');
        Route::post('/division/store', [DivisionController::class, 'store'])->name('division.store');
        Route::get('/division/edit/{id}', [DivisionController::class, 'edit'])->name('division.edit');
        Route::post('/division/update/{id}', [DivisionController::class, 'update'])->name('division.update');
        Route::delete('/division/delete/{id}', [DivisionController::class, 'destroy'])->name('division.delete');
        //district
        Route::get('/district/create', [DistrictController::class, 'create'])->name('district.create');
        Route::get('/district/managers', [DistrictController::class, 'index'])->name('district.index');
        Route::post('/district/store', [DistrictController::class, 'store'])->name('district.store');
        Route::get('/district/edit/{id}', [DistrictController::class, 'edit'])->name('district.edit');
        Route::post('/district/update/{id}', [DistrictController::class, 'update'])->name('district.update');
        Route::delete('/district/delete/{id}', [DistrictController::class, 'destroy'])->name('district.delete');
        //upazila
        Route::get('/upazila/create', [UpazilaController::class, 'create'])->name('upazila.create');
        Route::get('/upazila/managers', [UpazilaController::class, 'index'])->name('upazila.index');
        Route::post('/upazila/store', [UpazilaController::class, 'store'])->name('upazila.store');
        Route::get('/upazila/edit/{id}', [UpazilaController::class, 'edit'])->name('upazila.edit');
        Route::post('/upazila/update/{id}', [UpazilaController::class, 'update'])->name('upazila.update');
        Route::delete('/upazila/delete/{id}', [UpazilaController::class, 'destroy'])->name('upazila.delete');

        // slider
        Route::get('/slider/managers', [SliderController::class, 'index'])->name('slider.index');
        Route::get('/slider/create', [SliderController::class, 'create'])->name('slider.create');
        Route::post('/slider/store', [SliderController::class, 'store'])->name('slider.store');
        Route::get('/slider/edit/{id}', [SliderController::class, 'edit'])->name('slider.edit');
        Route::post('/slider/update/{id}', [SliderController::class, 'update'])->name('slider.update');
        Route::get('/slider/delete/{id}', [SliderController::class, 'destroy'])->name('slider.destroy');
        //general_setting
        Route::get('/general/setting', [GeneralSettingController::class, 'index'])->name('general_setting.index');
        Route::post('/general/setting/update/{id}', [GeneralSettingController::class, 'update'])->name('general_setting.update');
        //system setting
        Route::get('/system/setting', [SystemSettingController::class, 'index'])->name('system_setting.index');
        Route::post('/system/setting/update/{id}', [SystemSettingController::class, 'update'])->name('system_setting.update');
        //advertisement
        Route::get('/advertisement/managers', [AdController::class, 'index'])->name('ad.index');
        Route::get('/advertisement/create', [AdController::class, 'create'])->name('ad.create');
        Route::post('/advertisement/store', [AdController::class, 'store'])->name('ad.store');
        Route::get('/advertisement/edit/{id}', [AdController::class, 'edit'])->name('ad.edit');
        Route::post('/advertisement/update/{id}', [AdController::class, 'update'])->name('ad.update');
        Route::get('/advertisement/delete/{id}', [AdController::class, 'destroy'])->name('ad.delete');

        //user
        Route::get('/users/managers', [UserController::class, 'index'])->name('user.index');
        Route::get('/users/create', [UserController::class, 'create'])->name('user.create');
        Route::post('/users/store',  [UserController::class, 'store'])->name('user.store');
        Route::get('/users/edit/{id}', [UserController::class, 'edit'])->name('user.edit');
        Route::post('/users/update/{id}', [UserController::class, 'update'])->name('user.update');
        Route::get('/users/destroy/{id}', [UserController::class, 'destroy'])->name('user.destroy');
        Route::get('/bloger/list', [UserController::class, 'authorList'])->name('author.list');
        Route::get('/bloger/list/search', [UserController::class, 'authorListSearch'])->name('author.list.search');
        //user toggle buttom
        Route::post('/changeUserStatus', [UserController::class, 'changeUserStatus'])->name('changeUserStatus');
        //admin
        Route::get('/admin/managers', [UserController::class, 'admin_index'])->name('admin.index');
        Route::get('/admin/create', [UserController::class, 'admin_create'])->name('admin.create');
        Route::post('/admin/store', [UserController::class, 'admin_store'])->name('admin.store');
        Route::get('/admin/edit/{id}', [UserController::class, 'admin_edit'])->name('admin.edit');
        Route::post('/admin/update/{id}', [UserController::class, 'admin_update'])->name('admin.update');
        Route::get('/admin/destroy/{id}', [UserController::class, 'admin_destroy'])->name('admin.destroy');
        Route::get('online-user', [UserController::class, 'onlineUser'])->name('online.user');
        //role
        Route::get('/roles/managers', [RoleController::class, 'index'])->name('role.index');
        Route::get('/roles/create', [RoleController::class, 'create'])->name('role.create');
        Route::get('/roles/edit/{id}', [RoleController::class, 'edit'])->name('role.edit');
        Route::get('/roles/destroy/{id}', [RoleController::class, 'destroy'])->name('role.destroy');
        Route::post('/roles/store', [RoleController::class, 'store'])->name('role.store');
        Route::post('/roles/update/{id}', [RoleController::class, 'update'])->name('role.update');
        //staff
        Route::get('/staffs/managers', [StaffController::class, 'index'])->name('staff.index');
        Route::get('/staffs/create', [StaffController::class, 'create'])->name('staff.create');
        Route::get('/staffs/edit/{id}', [StaffController::class, 'edit'])->name('staff.edit');
        Route::get('/staffs/destroy/{id}', [StaffController::class, 'destroy'])->name('staff.destroy');
        Route::post('/staffs/update/{id}', [StaffController::class, 'update'])->name('staff.update');
        Route::post('/staffs/store', [StaffController::class, 'store'])->name('staff.store');
        // permission
        Route::get('/permission/managers', [PermissionController::class, 'index'])->name('permission.index');
        Route::get('/permission/create', [PermissionController::class, 'create'])->name('permission.create');
        Route::post('/permission/store', [PermissionController::class, 'store'])->name('permission.store');
        Route::get('/permission/edit/{id}', [PermissionController::class, 'edit'])->name('permission.edit');
        Route::post('/permission/update/{id}', [PermissionController::class, 'update'])->name('permission.update');
        Route::get('/permission/destroy/{id}', [PermissionController::class, 'destroy'])->name('permission.destroy');
        // reports
        Route::get('/report/search/result/show', [ReportController::class, 'user_search_report'])->name('report.user.searches');
        Route::get('/report/inventory', [ReportController::class, 'inventory'])->name('product.inventory');
        Route::get('/report/inventory/search', [ReportController::class, 'inventorySearch'])->name('inventory.search');
        Route::get('/report/inventory/sorting', [ReportController::class, 'inventorySorting'])->name('inventory.sorting');
        Route::get('/report/sales', [ReportController::class, 'salesReport'])->name('sales.report');
        Route::get('/report/sales/search', [ReportController::class, 'salesReportSearch'])->name('sales.report.search');
        Route::get('/report/sales/date', [ReportController::class, 'salesReportDate'])->name('sales.report.date');

        // Route::get('/customer/create', [UserController::class, 'customer_create'])->name('customer.create');
        Route::post('/customer/store', [UserController::class, 'customer_store'])->name('customer.store');
        Route::get('/customer/edit/{id}', [UserController::class, 'customer_edit'])->name('customer.edit');
        Route::post('/customer/update/{id}', [UserController::class, 'customer_update'])->name('customer.update');
        Route::get('/customer/destroy/{id}', [UserController::class, 'customer_destroy'])->name('customer.destroy');
        //client
        Route::get('/client/managers', [ClientController::class, 'index'])->name('client.index');
        Route::get('/client/create', [ClientController::class, 'create'])->name('client.create');
        Route::get('/client/edit/{id}', [ClientController::class, 'edit'])->name('client.edit');
        Route::get('/client/destroy/{id}', [ClientController::class, 'destroy'])->name('client.destroy');
        Route::post('/client/update/{id}', [ClientController::class, 'update'])->name('client.update');
        Route::post('/client/store', [ClientController::class, 'store'])->name('client.store');
        //client
        Route::get('/client-type/managers', [ClientTypeController::class, 'index'])->name('client.type.index');
        Route::get('/client-type/create', [ClientTypeController::class, 'create'])->name('client.type.create');
        Route::get('/client-type/edit/{id}', [ClientTypeController::class, 'edit'])->name('client.type.edit');
        Route::get('/client-type/destroy/{id}', [ClientTypeController::class, 'destroy'])->name('client.type.destroy');
        Route::post('/client-type/update/{id}', [ClientTypeController::class, 'update'])->name('client.type.update');
        Route::post('/client-type/store', [ClientTypeController::class, 'store'])->name('client.type.store');

        //work
        Route::get('/work-type/managers', [WorkTypeController::class, 'index'])->name('work.type.index');
        Route::get('/work-type/create', [WorkTypeController::class, 'create'])->name('work.type.create');
        Route::get('/work-type/edit/{id}', [WorkTypeController::class, 'edit'])->name('work.type.edit');
        Route::get('/work-type/destroy/{id}', [WorkTypeController::class, 'destroy'])->name('work.type.destroy');
        Route::post('/work-type/update/{id}', [WorkTypeController::class, 'update'])->name('work.type.update');
        Route::post('/work-type/store', [WorkTypeController::class, 'store'])->name('work.type.store');
        //complete work
        Route::get('/complete-work/managers', [CompleteWorkController::class, 'index'])->name('complete.work.index');
        Route::get('/complete-work/create', [CompleteWorkController::class, 'create'])->name('complete.work.create');
        Route::post('/complete-work/store', [CompleteWorkController::class, 'store'])->name('complete.work.store');
        Route::get('/complete-work/edit/{id}', [CompleteWorkController::class, 'edit'])->name('complete.work.edit');
        Route::post('/complete-work/update/{id}', [CompleteWorkController::class, 'update'])->name('complete.work.update');
        Route::get('/complete-work/destroy/{id}', [CompleteWorkController::class, 'destroy'])->name('complete.work.destroy');
        
        //work type
        Route::get('/work/managers', [WorkController::class, 'index'])->name('work.index');
        Route::get('/work/create', [WorkController::class, 'create'])->name('work.create');
        Route::get('/work/edit/{id}', [WorkController::class, 'edit'])->name('work.edit');
        Route::get('/work/destroy/{id}', [WorkController::class, 'destroy'])->name('work.destroy');
        Route::post('/work/update/{id}', [WorkController::class, 'update'])->name('work.update');
        Route::post('/work/store', [WorkController::class, 'store'])->name('work.store');
        Route::post('/work-type/completed', [WorkController::class, 'completedStatus'])->name('taggle-completed-work');
        
        
        //testimonial
        Route::get('/testimonial/managers', [TestimonialController::class, 'index'])->name('testimonial.index');
        Route::get('/testimonial/create', [TestimonialController::class, 'create'])->name('testimonial.create');
        Route::get('/testimonial/edit/{id}', [TestimonialController::class, 'edit'])->name('testimonial.edit');
        Route::get('/testimonial/destroy/{id}', [TestimonialController::class, 'destroy'])->name('testimonial.destroy');
        Route::post('/testimonial/update/{id}', [TestimonialController::class, 'update'])->name('testimonial.update');
        Route::post('/testimonial/store', [TestimonialController::class, 'store'])->name('testimonial.store');
        //service
        Route::get('/project/managers', [ServiceController::class, 'index'])->name('service.index');
        Route::get('/project/create', [ServiceController::class, 'create'])->name('service.create');
        Route::get('/project/edit/{id}', [ServiceController::class, 'edit'])->name('service.edit');
        Route::get('/project/destroy/{id}', [ServiceController::class, 'destroy'])->name('service.destroy');
        Route::post('/project/update/{id}', [ServiceController::class, 'update'])->name('service.update');
        Route::post('/project/store', [ServiceController::class, 'store'])->name('service.store');
        //------------event Route List-------
        Route::get('/event-manager', [EventController::class, 'index'])->name('event.index');
        Route::get('/event/create', [EventController::class, 'create'])->name('event.create');
        Route::post('/event/store', [EventController::class, 'store'])->name('event.store');
        Route::get('/event/{id}', [EventController::class, 'show'])->name('event.show');
        Route::get('/event/edit/{id}', [EventController::class, 'edit'])->name('event.edit');
        Route::post('/event/update/{id}', [EventController::class, 'update'])->name('event.update');
        Route::get('/event/destroy/{id}', [EventController::class, 'destroy'])->name('event.destroy');
        Route::post('/changeStatus', [EventController::class, 'changeStatus'])->name('changeEventStatus');
        //------------pagecategory Route List-------
        Route::get('/page/category', [PagecategoryController::class, 'index'])->name('pagecategory.index');
        Route::get('/page/category/create', [PagecategoryController::class, 'create'])->name('pagecategory.create');
        Route::post('/page/category', [PagecategoryController::class, 'store'])->name('pagecategory.store');
        Route::get('/page/category/{id}', [PagecategoryController::class, 'show'])->name('pagecategory.show');
        Route::get('/page/category/edit/{id}', [PagecategoryController::class, 'edit'])->name('pagecategory.edit');
        Route::post('/page/category/update/{id}', [PagecategoryController::class, 'update'])->name('pagecategory.update');
        Route::get('/page/category/destroy/{id}', [PagecategoryController::class, 'destroy'])->name('pagecategory.destroy');
        //------------page Route List-------
        Route::get('/pages/managers', [PageController::class, 'index'])->name('page.index');
        Route::get('/page/create', [PageController::class, 'create'])->name('page.create');
        Route::post('/page/store', [PageController::class, 'store'])->name('page.store');
        Route::get('/page/show/{id}', [PageController::class, 'show'])->name('page.show');
        Route::get('/page/edit/{id}', [PageController::class, 'edit'])->name('page.edit');
        Route::post('/page/update/{id}', [PageController::class, 'update'])->name('page.update');
        Route::get('/page/delete/{id}', [PageController::class, 'destroy'])->name('page.destroy');
        Route::get('/image/marge', [PageController::class, 'imageMarge'])->name('image.marge');
        Route::post('/image/marge/store', [PageController::class, 'imageMargeStore'])->name('imageMarge.store');
        //------------pagecategory Route List-------
        Route::get('/partner/manage', [PartnerController::class, 'index'])->name('partner.index');
        Route::get('/partner/create', [PartnerController::class, 'create'])->name('partner.create');
        Route::post('/partner/store', [PartnerController::class, 'store'])->name('partner.store');
        Route::get('/partner/show/{id}', [PartnerController::class, 'show'])->name('partner.show');
        Route::get('/partner/edit/{id}', [PartnerController::class, 'edit'])->name('partner.edit');
        Route::post('/partner/update/{id}', [PartnerController::class, 'update'])->name('partner.update');
        Route::get('/partner/destroy/{id}', [PartnerController::class, 'destroy'])->name('partner.destroy');

        //new route end
        Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
        Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

        //user profile
        Route::get('/user/profile',[UserController::class, 'profile_index'])->name('user.profile.index');
        Route::get('/user/profile/edit/{id}', [UserController::class, 'profile_edit'])->name('user.profile.edit');
        Route::post('/user/profile/update/{id}',[UserController::class,'profile_update'])->name('user.profile.update');
        //user pass change
        Route::get('/user/password/change/', [UserController::class, 'password_edit'])->name('user.password.edit');
        Route::post('/user/password/update/',[UserController::class,'password_update'])->name('user.password.update');
        Route::get('/category-sub-category/{category_id?}', [PostController::class, 'categorySubCategoyAJAX'])->name('category.subcategory.ajax');
        Route::get('/parent-category-category/{id?}', [PostController::class, 'PcategoryCategoryAJAX'])->name('Pcategory.category.ajax');


    }); //prefix
});
require __DIR__.'/auth.php';
