<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title')</title>
    <!-- Favicon and Touch Icons-->
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('settings/'. setting('favicon')) }}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('settings/'. setting('favicon')) }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('settings/'. setting('favicon')) }}">
    <meta name="description" content="">
    <meta name="author" content="">
    <link href="{{ asset('/backend/img/logo/logo.png') }}" rel="icon">
    <link href="{{ asset('/backend/vendor/fontawesome-free/css/all.min.css') }}" rel="stylesheet" type="text/css">
    <!-- Select2 -->
    <link href="{{ asset('/backend/vendor/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('/backend/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css">
    <!-- Bootstrap Touchspin -->
    <link href="{{ asset('/backend/vendor/bootstrap-touchspin/css/jquery.bootstrap-touchspin.css') }}" rel="stylesheet">
    <link href="{{ asset('/backend/css/admin-core.min.css') }}" rel="stylesheet">
    <link href="{{ asset('/backend/css/admin-style.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/toastr/toastr.min.css') }}" rel="stylesheet">
    @yield('extra_css')
    <style type="text/css">
        /*select2 */
        .select2-container .select2-selection--single{
            height: 44px !important;
        }
        .select2-container--default .select2-selection--single .select2-selection__rendered{
            color: #6e707e !important;
            line-height: 44px !important;
        }
        .select2-container--default .select2-selection--single .select2-selection__arrow{
            height: 42px !important;
        }
        :focus-visible {
            outline: none;
        }
        .select2-selection__arrow{
            height: 42px !important;
        }
        .topbar .rootUrl:hover {
            background-color: #fff;
            box-shadow: unset !important;
        }

        .feature_image {
            width: 50px;
        }
        /*toaster*/
        .toast-message {
            font-size: 12px;
        }
        #toater p {
            padding: 0px;
            margin: 0px;
            color: #fff;
        }
        /*image preview*/
        .custom-file-label {
            overflow: hidden;
        }
        .profileImgShow {
            width: 80px;
        }
        /*svg icon*/
        .sidebar .nav-item .nav-link svg {
            stroke: #979797;
            transition: .3s;
        }
        .sidebar .nav-item .nav-link {
            display: block;
            width: 100%;
            text-align: left;
            padding: 1.1rem 1rem;
            width: 14rem;
        }
        .sidebar .nav-item .nav-link:hover {
            color: var(--primary) !important;
        }
        .sidebar .nav-item .nav-link:hover .sb-nav-link-icon svg, .sidebar .nav-item .nav-link:hover svg {
            stroke: var(--primary);
            -webkit-transform: rotateY(-180deg);
            transform: rotateY(-180deg);
            transition: .3s;
        }
        /*action btn*/
        .btn-icon {
            padding: 9px 8px 7px !important;
            width: 28px !important;
            height: 28px !important;
            line-height: 1;
            font-size: 10px;
        }
        .btn-circle {
            border-radius: 50em;
        }
        .btn-soft-success {
            background-color: rgba(10, 187, 117, .15);
            color: #0abb75;
        }
        .btn-soft-success:hover {
            background-color: #0abb75;
            color: #fff;
        }
        .btn-soft-primary {
            background-color: rgba(55, 125, 255, .15);
            color: #377dff;
        }
        .btn-soft-primary:hover {
            background-color: #377dff;
            color: #fff;
        }
        .btn-soft-warning {
            background-color: rgba(255, 197, 25, .15);
            color: #ffc519;
        }
        .btn-soft-warning:hover {
            background-color: #ffc519;
            color: #fff;
        }
        .btn-soft-danger {
            background-color: rgba(239, 72, 106, .15);
            color: #ef486a;
        }
        .btn-soft-danger:hover {
            background-color: #ef486a;
            color: #fff;
        }
        /*  menu*/
        .header.active-menu #mainMenu {
            display: block !important;
        }
        /*General Settings*/
        .system__logo__section .thumb {
            margin-top: 30px;
            text-align: center;
            width: 65%;
            height: 115px;
            box-shadow: 0px 0px 9px #e1e1e1;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }
        .system__logo__section .lbl {
            display: block;
        }
        .system__logo__section .thumb img {
            width: 100px !important;
            text-align: center;
            max-height: 80px !important;
        }
        .system__logo__section i {
            font-size: 40px;
            margin-top: 10px;
            color: #33c0f9;
            cursor: pointer;
        }
        /*Action Button*/
        .col__id {
            width: 80px;
        }
        .col__action__body {
            width: 210px;
        }
        @media (max-width: 981px) {
            .sidebar.toggled .nav-item .nav-link {
                padding-left: 1.5rem;
            }
            .col__action__body {
                display: flex;
                width: auto;
            }
            .col__action__body .btn-sm {
                padding: .1rem .25rem;
                font-size: .9rem;
                line-height: 1.5;
                border-radius: .2rem;
                margin-right: 5px;
            }
        }
    </style>
</head>
<body id="page-top">
<div id="wrapper">
    <!-- Sidebar -->
@include('back.parts.sidebar')
<!-- Sidebar -->
    <div id="content-wrapper" class="d-flex flex-column">
        <div id="content">
            <!-- TopBar -->
        @include('back.parts.header')
        <!-- Topbar -->
            <!-- Container Fluid-->
        @yield('content')
        <!---Container Fluid-->
        </div>
        <!-- Footer -->
    @include('back.parts.footer')
    <!-- Footer -->
    </div>
</div>
<!-- Scroll to top -->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
<script src="{{ asset('/backend/vendor/jquery/jquery.min.js') }}"></script>
<script src="{{ asset('/backend/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('/backend/vendor/jquery-easing/jquery.easing.min.js') }}"></script>
<script src="{{ asset('backend/toastr/toastr.min.js') }}"></script>
<!-- Select2 -->
<script src="{{ asset('/backend/vendor/select2/dist/js/select2.min.js') }}"></script>
<script src="{{ asset('/backend/js/ruang-admin.min.js') }}"></script>
<!-- Bootstrap Touchspin -->
<script src="{{ asset('/backend/vendor/bootstrap-touchspin/js/jquery.bootstrap-touchspin.js') }}"></script>

<script src="//cdn.ckeditor.com/4.6.2/standard/ckeditor.js"></script>
<script>
    var options = {
        filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
        filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=6eEQ6t5njG6CbhhmQfj9U1vzpp1BalkmsOf0S56O',
        filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
        filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token=6eEQ6t5njG6CbhhmQfj9U1vzpp1BalkmsOf0S56O'
    };
</script>
<script src="{{ asset('backend/js/stand-alone-button.js') }}"></script>

<script type="text/javascript">
    $('#lfm').filemanager('image');
</script>


@yield('extra_js')
<script>
    $(document).ready(function () {
        $('.select2-single').select2();
        $('.select2-multiple').select2();
        $('#position').TouchSpin({
            min: 0,
            max: 500,
            initval: 0,
            boostat: 5,
            maxboostedstep: 10,
            verticalbuttons: true,
        });
        //image preview
        $('.profile-img-input').change(function (e) {
            var reader = new FileReader();
            $('.custom-file-label').html(e.target.files[0].name);
            reader.onload = function (e) {
                $('.profileImgShow').attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        })
    });
    @if(Session::has('message'))
        toastr.options =
        {
            "closeButton": true,
            "progressBar": true
        }
    toastr.success("{{ session('message') }}");
    @endif
    @if(Session::has('success'))
        toastr.options =
        {
            "closeButton": true,
            "progressBar": true
        }
    toastr.success("{{ session('success') }}");
    @endif
    @if(Session::has('danger'))
        toastr.options =
        {
            "closeButton": true,
            "progressBar": true
        }
    toastr.error("{{ session('danger') }}");
    @endif
    @if(Session::has('info'))
        toastr.options =
        {
            "closeButton": true,
            "progressBar": true
        }
    toastr.info("{{ session('info') }}");
    @endif
    @if(Session::has('warning'))
        toastr.options =
        {
            "closeButton": true,
            "progressBar": true
        }
    toastr.warning("{{ session('warning') }}");
    @endif
</script>
</body>
</html>