@extends('layouts.frontend')
@section('meta_info')
    @php
        $setting = setting();
    @endphp
    <title>{{ $setting->site_title }}</title>
    <meta name="title" content="{{ $setting->site_title }}"/>
    <meta name="keywords" content="{{ $setting->meta_keywords }}"/>
    <meta name="description" content="{{ $setting->meta_description }}">
    <meta name="author" content="{{ $setting->meta_author }}">
    <meta property="og:title" content="{{ $setting->meta_title }}"/>
    <meta property="og:description" content="{{ $setting->meta_description }}">
    <meta property="og:image" content="{{ asset('/settings/' . $setting->meta_image) }}"/>
    <meta property="og:url" content="{{ $setting->site_url }}"/>
    <meta property="og:site_name" content="{{ $setting->site_name }}">
    <meta name="twitter:url" content="{{ $setting->site_url }}"/>
    <meta name="twitter:title" content="{{ $setting->meta_title }}"/>
    <meta name="twitter:description" content="{{ $setting->meta_description }}"/>
    <meta name="twitter:image" content="{{ asset('/settings/' . $setting->meta_image) }}"/>
@endsection
@section('css')
    <style>
    .top-50 {
            top: 50%;
        }
        .work-image {
            width: 100%;
            height: 420px !important;
            object-fit: cover;
        }

        .work-image.count__4 {
            height: 205px !important;
        }

        @media (min-width: 767px) {
            .nav-side-menu .menu-list .menu-content {
                display: block;
                height: 420px;
            }
        }
    </style>
@endsection
@section('js')
    <script></script>
@endsection

@section('content')
    <div class="container">
        <div class="row margin150">
            <div class="col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1 col-xs-12">
                <h3 class=" text-left">{{ $work->workType?->name ?? 'N/A'}}</h3>
            </div>
        </div>
    </div>


    <div class="container fadeInUp animated">
        <div class="row">
            <div class="col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1 col-xs-12">
                <div class="col-md-3 col-sm-3 col-xs-12">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="nav-side-menu">
                                <div class="menu-list">
                                    <div class="menu-client-container">
                                        <ul id="header_menu menu-content" class="menu-content out">
                                            @if (!empty($workItems))
                                                @foreach ($workItems as $key=> $workItem)
                                                    <li class="menu-item {{ request()->routeIs('work.single') && request()->slug == $workItem->slug ? 'active current-menu-item' : '' }}">
                                                        <a href="{{ route('work.single',['id'=>$workItem->id, 'slug'=>$workItem->slug]) }}"
                                                           aria-current="page">
                                                            {{ $workItem->name ?? '' }}
                                                        </a>
                                                    </li>
                                                @endforeach
                                            @endif
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            @if (!empty($work))
                                @if (count($work->images) == 2 || count($work->images) == 4)
                                    <div class="text-center" style="margin:40px 0 0 30px;">
                                        <img class="img-responsive" src="{{ asset('defaults/idea-icon.png')}}">
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
                <!----------------------------------Part 03------------------------->
                <div class="col-md-9">
                    @if (!empty($work))
                        <div class="row">
                            @if (count($work->images) == 1 || count($work->images) == 3 || count($work->images) >= 5)
                                @if(count($work->images) == 1)
                                    {{-- Single Image Layout --}}
                                    <div class="col-md-9">
                                        @foreach ($work->images as $image)
                                            <img class="img-responsive mb-2 work-image"
                                                 src="{{ asset($image) }}"
                                                 alt="{{ $work->name ?? '' }}"/>
                                        @endforeach
                                    </div>

                                    <div class="col-md-3 work__des">
                                        <h3 class="back-lightblue text-center margin0">{!! $work->name ?? '' !!}</h3>
                                        <div style="margin-top: 3px;">{!! $work->description ?? '' !!}</div>
                                    </div>
                                @else
                                    <div class="col-md-9">
                                        {{-- slider --}}
                                        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
                                            {{-- Indicators --}}
                                            <ol class="carousel-indicators">
                                                @foreach ($work->images as $key => $image)
                                                    <li data-target="#carousel-example-generic"
                                                        data-slide-to="{{ $key }}"
                                                        class="{{ $key == 0 ? 'active' : '' }}">
                                                    </li>
                                                @endforeach
                                            </ol>

                                            {{-- Slides --}}
                                            <div class="carousel-inner">
                                                @foreach ($work->images as $key => $image)
                                                    <div class="item {{ $key == 0 ? 'active' : '' }}">
                                                        <img class="img-responsive img-center work-image"
                                                             src="{{ asset($image) }}"
                                                             alt="{{ $work->name ?? '' }}">
                                                    </div>
                                                @endforeach
                                            </div>

                                            {{-- Controls --}}
                                            <a class="left carousel-control top-50" href="#carousel-example-generic" data-slide="prev">
                                                <span class="fa fa-chevron-left"></span>
                                            </a>
                                            <a class="right carousel-control top-50" href="#carousel-example-generic" data-slide="next">
                                                <span class="fa fa-chevron-right"></span>
                                            </a>
                                        </div>
                                    </div>

                                    <div class="col-md-3 work__des">
                                        <h3 class="back-lightblue text-center margin0">{!! $work->name ?? '' !!}</h3>
                                        <div style="margin-top: 3px;">{!! $work->description ?? '' !!}</div>
                                    </div>
                                @endif
                            @else
                                <div class="col-md-12">
                                    <div class="row">
                                        @foreach ($work->images as $image)
                                            <div class="col-md-6 col-sm-4 col-xs-6">
                                                <img class="img-responsive img-center work-image count__4 mb-3"
                                                     style="margin-bottom:15px;" src="{{ asset($image) }}"
                                                     alt="{{ $work->name ?? '' }}"/>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="col-md-12" style="margin-top:10px;">
                                    <h3 class="back-lightblue text-left margin0">{!! $work->name ?? '' !!}</h3>
                                    <div class="mt-2 mb-3">{!! $work->description ?? '' !!}</div>
                                </div>

                            @endif
                        </div>
                    @else
                        <p class="text-center text-muted">No works found.</p>
                    @endif
                </div>
                <!-----Logo Item End------->
            </div>
        </div>
    </div>

    {{-- ============ --}}

    <!---------------Part 04----------------->
    <div class="container margin100 fadeInUp animated">
        <div
            class="col-lg-10 col-lg-offset-1  col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1 col-xs-12 padding-zero">
            <!-- Begin Slide 1 -->
            <div class="col-md-6 col-sm-6 col-xs-12 padding-zero">
                <img width="500" height="350" src="{{ asset('/defaults/home_one.jpg') }}"
                     class="img-responsive img-thumbnail wp-post-image" alt="Advertiesment-01" title="Advertiesment-01"
                     srcset="{{ asset('/defaults/home_one.jpg') }} 500w, {{ asset('/defaults/home_one.jpg') }} 300w"
                     sizes="(max-width: 500px) 100vw, 500px"/>
            </div>
            <!-- End Slide 1 -->
            <!-- Begin Slide 1 -->
            <div class="col-md-6 col-sm-6 col-xs-12 padding-zero">
                <img width="500" height="350" src="{{ asset('/defaults/home_two.jpg') }}"
                     class="img-responsive img-thumbnail wp-post-image" alt="Advertiesment-02" title="Advertiesment-02"
                     srcset="{{ asset('/defaults/home_two.jpg') }} 500w, {{ asset('/defaults/home_two.jpg') }} 300w"
                     sizes="(max-width: 500px) 100vw, 500px"/>
            </div>
            <!-- End Slide 1 -->
        </div>
    </div>
@endsection
