@extends('layouts.frontend')
@section('meta_info')
    <title>{{ setting('site_title') }}</title>
    <meta name="description" content="{{ setting('meta_description') }}">
    <meta name="keywords" content="{{ setting('meta_keywords') }}">
    <meta name="author" content="{{ setting('meta_author') }}">
@endsection
@section('content')
    <section class="container pb-5 mb-md-2 mb-lg-4">
        <h3 class="border-bottom pb-4">Terms & Condition</h3>
        <div class="row pt-2 pt-md-3">
            <div class="col-md-12">
                <p class="fs-lg pe-lg-4 mb-1 mb-lg-4">
                    Welcome to HOTELIERS! By accessing or using our website, payment gateway, services and initiatives,
                    you agree to comply with and be bound by the following terms and conditions. Please read them
                    carefully.</p>
                <h4>Acceptance of Terms</h4>
                <p>By using our website, payment gateway and services you acknowledge that you have read, understood and
                    agree to these terms. If you do not agree, please refrain from using our services.</p>
                <h4>Use of Services</h4>
                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Our website and services are intended for lawful use only.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        You agree not to misuse our platform, including but not limited to unauthorized access, data
                        scraping or distribution of harmful content.
                    </li>
                </ul>
                <h4>Intellectual Property</h4>
                <p>All content on this website, including text, graphics, logos and images, is the property of HOTELIERS
                    and is protected by intellectual property laws. Unauthorized use or reproduction is prohibited.</p>
                <h4>User Contributions</h4>
                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        By submitting content (e.g., comments, feedback, or stories), you grant HOTELIERS a
                        non-exclusive, royalty-free license to use, modify and share it for our initiatives.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        You are responsible for ensuring your contributions do not violate any third-party rights or
                        contain harmful or offensive material.
                    </li>
                </ul>

                <h4>Donations, Payments and Registrations</h4>
                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        All payments are processed securely through our trusted payment gateway.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        All donations and payments are processed securely.
                    </li>

                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Donations are non-refundable unless otherwise stated.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Registrations and certain event payments are non-refundable unless otherwise stated.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        You must provide accurate and complete information for successful transactions.
                    </li>
                </ul>
                <h4>Disputes and Refund</h4>
                <p>Refunds for eligible payments will be processed as per our Return Policy. For any disputes or issues,
                    contact us at support@hoteliersbd.com. We will resolve the matter promptly and fairly.</p>
                <h4>Limitation of Liability</h4>
                <p>HOTELIERS is not liable for any errors or delays, direct, indirect, or incidental damages arising or
                    caused by payment processors or third-party services.</p>
                <h4>Changes to Terms</h4>
                <p>We reserve the right to update these terms and conditions at any time. Changes will be posted on this page, and continued use of our services constitutes acceptance of the updated terms.</p>
                <h4>Governing Law</h4>
                <p>These terms are governed by the laws of Bangladesh and any disputes will be resolved under its jurisdiction. For questions or concerns please contact us at support@hoteliersbd.com.</p>
            </div>
        </div>
    </section>
@endsection
