@extends('layouts.frontend')
@section('meta_info')
    @php
        $setting = setting();
    @endphp
    <title>Our Team | {{ $setting->site_title }}</title>
    <meta name="title" content="Our Team | {{ $setting->site_title }}"/>
    <meta name="keywords" content="{{ $setting->meta_keywords }}"/>
    <meta name="description" content="{{ $setting->meta_description }}">
    <meta name="author" content="{{$setting->meta_author}}">
    <meta property="og:title" content="Our Team | {{ $setting->meta_title }}"/>
    <meta property="og:description" content="{{ $setting->meta_description }}">
    <meta property="og:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
    <meta property="og:url" content="{{$setting->site_url}}"/>
    <meta property="og:site_name" content="{{ $setting->site_name }}">
    <meta name="twitter:url" content="{{ $setting->site_url }}"/>
    <meta name="twitter:title" content="Our Team | {{ $setting->meta_title }}"/>
    <meta name="twitter:description" content="{{ $setting->meta_description }}"/>
    <meta name="twitter:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
@endsection
@section('css')
    <style>
        /*.form-control[readonly]{*/
        /*    cursor: not-allowed; !* Change cursor to indicate it's not editable *!*/
        /*    background-color: #e0e0e0; !* Light grey background to show it's disabled *!*/
        /*    color: #796f6f; !* Grey text color to show it's inactive *!*/
        /*}*/


    </style>
@endsection
@section('js')
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const form = document.querySelector("form");
            const submitButton = form.querySelector("button[type='submit']");

            form.addEventListener("submit", function () {
                submitButton.disabled = true;
                submitButton.innerHTML = "Processing...";
            });
        });
    </script>
@endsection

@section('content')

    <section class="team py-5 my-2 my-md-4 my-lg-5">
        <div class="container">
            <div class="d-md-flex align-items-center justify-content-between text-center text-md-start pt-md-1 pt-lg-3">
                <h3 class="mb-4 mb-md-0 me-md-3">Advisor</h3>
            </div>
            <div class="row d-flex justify-content-center g-4 my-5">
                <div class="col-lg-3">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t1.jpg" class="rounded-3" alt="Shahid Hamid FIH">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-2">Shahid Hamid FIH</h3>
                        </div>
                    </div>
                </div>

                <!-- Item -->
                <div class="col-lg-3">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t2.jpg" class="rounded-3" alt="Sharif Sadi">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-2">Sharif Sadi</h3>
{{--                            <p class="fs-sm mb-0">Principal Consultant, Twitch</p>--}}
                        </div>
                    </div>
                </div>

                <!-- Item -->
                <div class="col-lg-3">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t3.jpg" class="rounded-3" alt="Md. Al-Amin">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-2">Md. Al-Amin</h3>
                        </div>
                    </div>
                </div>
            </div>
<hr>
            <div class="d-md-flex align-items-center justify-content-between text-center text-md-start pt-md-1 pt-lg-3 my-5 py-4">
                <h3 class="mb-3 mb-md-0 me-md-3">Organizer</h3>
            </div>
            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 row-cols-lg-4 g-4 mt-2 mt-lg-4">
                <!-- Item -->
                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t4.jpg" class="rounded-3" alt="Md. Alamgir Hossan">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Md. Alamgir Hossan</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <!-- Item -->
                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t5.jpg" class="rounded-3" alt="Tanvir Hassan">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Tanvir Hassan</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <!-- Item -->
                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t6.jpg" class="rounded-3" alt="Mezba Uddin">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Mezba Uddin</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <!-- Item -->
                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t7.jpg" class="rounded-3" alt="Majumder Himel">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Majumder Himel</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <!-- Item -->
                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t8.jpg" class="rounded-3" alt="Farhad H. Mazumder">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Farhad H. Mazumder</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t9.jpg" class="rounded-3" alt="Tuman Mehetar">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Tuman Mehetar</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t10.jpg" class="rounded-3" alt="Sadee Islam">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Sadee Islam</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t11.jpg" class="rounded-3" alt="Saif Ul Alam Tanzu">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Saif Ul Alam Tanzu</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t12.jpg" class="rounded-3" alt="Salah Uddin Rajib">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Salah Uddin Rajib</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t13.jpg" class="rounded-3" alt="Ohidulislam Ove">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Ohidulislam Ove</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t14.jpg" class="rounded-3" alt="Tanjir Hasan">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Tanjir Hasan</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card card-hover border-0 bg-transparent">
                        <div class="position-relative">
                            <img src="/img/team/t15.jpg" class="rounded-3" alt="Sakhawat Saki">
                            <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                                <span class="position-absolute top-0 start-0 w-100 h-100 bg-primary opacity-35 rounded-3"></span>
                                <div class="position-relative d-flex zindex-2">
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook btn-sm bg-white me-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-center p-3">
                            <h3 class="fs-lg fw-semibold pt-1 mb-1">Sakhawat Saki</h3>
                            <p class="fs-sm mb-0">Organizer</p>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>

    </section>
@endsection