@extends('layouts.backend')
@section('title')
    Admin | Post create
@endsection
@section('extra_css')
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/tag-it/2.0/css/jquery.tagit.min.css" rel="stylesheet" type="text/css">
@endsection

@section('extra_js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js" type="text/javascript" charset="utf-8"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/tag-it/2.0/js/tag-it.min.js" type="text/javascript" charset="utf-8"></script>
<script>
   $(document).ready(function () {
      $("#myTags").tagit({
          fieldName: 'tags',
          removeConfirmation: true,
          allowSpaces: true,
          tagSource: [<?php echo '"' . implode('","', $tags) . '"' ?>],
          autocomplete: {
              appendTo: ".ui-front",
              delay: 0,
              minLength: 2,
              source: this.tagSource
          }
      });
      $(".ui-autocomplete").appendTo($(".ui-front"));

       
      $('#sticky_position').TouchSpin({
         min: 0,
         max: 1000,
         initval: 0,
         boostat: 5,
         maxboostedstep: 10,
         verticalbuttons: true,
      });

      let sticky = $("#sticky");
      sticky.on('click', function () {
          if (sticky.is(':checked')) {
              sticky.val(1);  // checked
              $("#sticky_position_input").css("display", "block");
          } else {
              sticky.val(0);
              $("#sticky_position_input").css("display", "none");
              $("#sticky_position").val('');
          }
      });

      //ajax category subCsategory
      $('#category_list').on('change', function (e) {
          var category_id = e.target.value;
          if (category_id) {
              $.ajax({
                  url: "{{ route('category.subcategory.ajax') }}/" + category_id,
                  type: "get",
                  dataType: "json",
                  success: function (data) {
                      $("#sub_cat_list").empty();
                      $("#sub_cat_list").append('<option selected value="">--Select Sub Category--</option>')
                      $.each(data, function (key, value) {
                          // console.log(value.id);
                          $('#sub_cat_list').append('<option value="' + value.id + '">' + value.name + '</option>')
                      })
                  }
              })
          } else {
          }
      });
   });

 </script>
@endsection

@section('content')
   
<div class="container-fluid">
    <form role="form" method="post" action="{{ route('writer.draft2post',['id'=>$post->id]) }}" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header py-3 align-items-center justify-content-between">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary">Edit Post</h6>
                            </div>
                            <div class="col-md-6 create__post text-right">
                                <a href="{{ route('writer.post.index') }}" class="btn btn-primary">
                                    View All
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label class="mb-1">Headline</label>
                            <input name="headline" value="{{$post->headline}}" type="text" maxlength="250"
                            class="form-control"
                            required="required">
                        </div>
                        <div class="form-group">
                             <label class="mb-1">Intro</label>
                             <input name="intro" value="{{$post->post}}" placeholder="Intro" type="text" maxlength="250" class="form-control">
                          </div>

                        <div class="form-group body__edit">
                            <label class="mb-1">Post Content</label>
                            <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.11/tinymce.min.js"></script>
                            <textarea id="content24" name="content" class="form-control my-editor"
                            rows="15">{!! $post->content !!}</textarea>
                            <script>
                                var editor_config = {
                                    path_absolute: "/",
                                    selector: "#content24",
                                    plugins: [
                                        "textcolor advlist autolink lists link image charmap print preview hr anchor pagebreak",
                                        "searchreplace wordcount visualblocks visualchars code fullscreen",
                                        "insertdatetime media nonbreaking save table directionality",
                                        "emoticons template paste textcolor colorpicker textpattern"
                                        ],
                                    toolbar: "forecolor backcolor insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                                    relative_urls: false,
                                    file_browser_callback: function (field_name, url, type, win) {
                                        var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                                        var y = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;

                                        var cmsURL = editor_config.path_absolute + 'laravel-filemanager?field_name=' + field_name;
                                        if (type == 'image') {
                                            cmsURL = cmsURL + "&type=Images";
                                        } else {
                                            cmsURL = cmsURL + "&type=Files";
                                        }

                                        tinyMCE.activeEditor.windowManager.open({
                                            file: cmsURL,
                                            title: 'Filemanager',
                                            width: x * 0.8,
                                            height: y * 0.8,
                                            resizable: "yes",
                                            close_previous: "no"
                                        });
                                    }
                                };
                                tinymce.init(editor_config);
                            </script>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="form-group d-flex">
                             <label class="m-3">Is Lead?</label>
                             <input type="checkbox" class="m-3" id="sticky" value="0" name="sticky">
                             <div class="" style="display: none; width: 150px;" id="sticky_position_input">
                                <input class="form-control" id="sticky_position" type="number" name="sticky_position" min="0" placeholder="Position">
                             </div>
                          </div>
                        <div class="form-group" class="profile-img">
                            <label class="mb-1">Image <span style="color: #f10000; font-weight: bold;">(width: 700px; height: 450px)</span></label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input profile-img-input"  id="photo" name="image">
                                <label class="custom-file-label" for="customFile">Choose file</label>
                            </div>
                            <span class="text-danger">{{ $errors->has('image') ? $errors->first('image'):''}}</span>
                            @if(!empty($post->image))
                            <div class="pt-1" id="profileLabel" for="photo">
                                <img class="profileImgShow"
                                src="{{$post->image}}">
                            </div>
                            @else
                            <div class="pt-1" id="profileLabel" for="photo">
                                <img class="profileImgShow"
                                src="{{ asset('defaults/default3.png')}}">
                            </div>
                            @endif
                        </div>
                        <div class="form-group ui-front">
                             <label class="mb-1" for="myTags">Keywords</label>
                             <input type="text" id="myTags" name="tag_list" value="@foreach($post->Tag as $tag){{$tag->name}}, @endforeach" class="form-control">
                        </div>

                        
                        <div class="form-group">
                            <label for="category_id"> Category <span class="text-danger">*</span></label>
                            <select class="form-control select2-single" id="category_list" name="category_id[]" required="">
                                @foreach($post->Category as $category)
                                            <option value="{!! $category->id !!}"
                                                    selected>{!! $category->name !!}</option>
                                        @endforeach
                                @foreach($categories as $category)
                                <option value="{{ $category->id }}">{!! $category->name !!}</option>
                                @endforeach
                            </select>
                        </div>


                  <div class="form-group">
                     <label for="sub_cat_id"> Sub Category</label>
                     <select class="form-control select2-single" id="sub_cat_list" name="sub_category_id">
                         <option value="{{$post->sub_cat_id}}" selected="">Select Sub Category</option>
                     </select>
                  </div>

                        <div class="form-group">
                            <label class="mb-1">Publication status</label>
                            <select class="form-control" name="status">
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="float-right btn btn-success">Update</button>
                            <a href="{{ route('writer.draft.index') }}" class="float-right btn btn-danger mr-2">Cancel</a>
                        </div>
                    </div>
                </div>
            </div> <!--col-->
        </div>
    </form>
</div>

@endsection



