@extends('layouts.backend')
@section('title')
    Admin | create 
@endsection

@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <div class="col-md-6">
                        <h6 class="m-0 font-weight-bold text-primary">Add Work</h6>
                    </div>
                    <div class="col-md-6">
                        <a href="{{ route('work.index') }}" class="btn btn-primary float-right">View All</a>
                        <a href="{{ route('work.type.index') }}" class="btn btn-primary float-right mr-2">Type</a>
                    </div>
                </div>
                <div class="card-body">
                    <form role="form" method="post" action="{{ route('work.store') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group row">
                            <div class="col-md-3">
                                <label class="" for="work_type_id">Type <span class="text-danger">*</span></label>
                                <select class="form-control select2" name="work_type_id" id="work_type_id" required>
                                    <option value="">-Select Type-</option>
                                    @foreach ($types as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger">{{ $errors->has('work_type_id') ? $errors->first('work_type_id'):''}}</span>
                            </div>
                            <div class="col-md-9">
                                <div class="form-group">
                                    <label class="" for="name">Name <span class="text-danger">*</span></label>
                                        <input class=" form-control" name="name" placeholder="Name" type="text" maxlength="200" required>
                                        <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="" for="description">Description </label>
                                    <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.11/tinymce.min.js"></script>
                                    <textarea class="content" id="description" name="description" rows="8">  </textarea>
                                    <script>
                                        var editor_config = {
                                            path_absolute: "/",
                                            selector: "#description",
                                            plugins: [
                                                "textcolor advlist autolink lists link image charmap print preview hr anchor pagebreak",
                                                "searchreplace wordcount visualblocks visualchars code fullscreen",
                                                "insertdatetime media nonbreaking save table directionality",
                                                "emoticons template paste textcolor colorpicker textpattern"
                                            ],
                                            toolbar: "forecolor backcolor insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                                            relative_urls: false,
                                            file_browser_callback: function (field_name, url, type, win) {
                                                var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                                                var y = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;

                                                var cmsURL = editor_config.path_absolute + 'laravel-filemanager?field_name=' + field_name;
                                                if (type == 'image') {
                                                    cmsURL = cmsURL + "&type=Images";
                                                } else {
                                                    cmsURL = cmsURL + "&type=Files";
                                                }

                                                tinyMCE.activeEditor.windowManager.open({
                                                    file: cmsURL,
                                                    title: 'Filemanager',
                                                    width: x * 0.8,
                                                    height: y * 0.8,
                                                    resizable: "yes",
                                                    close_previous: "no"
                                                });
                                            }
                                        };
                                        tinymce.init(editor_config);
                                    </script>
                                    <span class="text-danger">{{ $errors->has('description') ? $errors->first('description'):''}}</span>
                                </div>
                            </div>


                        </div>
                        <div class="form-group">
                            <label class="mb-1" for="images">Images <span class="text-danger">*</span></label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input profile-img-input" 
                                    id="images" name="images[]" multiple required>
                                <label class="custom-file-label" for="customFile">Choose files</label>
                            </div>
                            <span class="text-danger">{{ $errors->has('images') ? $errors->first('images'):''}}</span>

                            {{-- Preview Section --}}
                            <div class="pt-1 d-flex flex-wrap gap-2" id="previewImages">
                                <img class="profileImgShow" src="{{ asset('defaults/default3.png')}}" style="max-height: 80px;">
                            </div>
                        </div>
                        <button type="submit" class="float-right btn btn-primary">Create</button>
                    </form>
                </div>
            </div>
        </div> <!--col-5-->
    </div>
</div>
@endsection

