@extends('layouts.backend')
@section('title')
    Admin | Online users
@endsection

@section('extra_css')

@endsection

@section('extra_js')

@endsection

@section('content')
    <div class="container-fluid">
        @include('back.parts.message')
        <div class="row justify-content-center">
            <div class="col-lg-11">
                <div class="card mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                      <h6 class="m-0 font-weight-bold text-primary">Online Users</h6>
                    </div>
                        <div class="table-responsive">
                            <table class="table align-items-center table-flush">
                                <thead class="thead-light">
                                <tr>
                                <tr>
                                    <th class="text-center col__id">ID</th>
                                    <th>Name</th>
                                    <th>User</th>
                                    <th class="text-center">Photo</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($users as $row)
                                    <tr>
                                        <td class="text-center">{{$row->id}}</td>
                                        <td>{{$row->name}}</td>
                                        <td>{{$row->email}}</td>
                                        <td class="text-center"><img class="img-profile rounded-circle" width="50" src="{{$row->photo ? asset('/profile/'.$row->photo) : asset('/defaults/avatar01.png')}}"></td>
                                        
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                            <div class="pagination px-3 pb-2">
                                {{$users->links()}}
                            </div>
                        </div>
                </div>
            </div> <!--col-6-->
        </div>
    </div>
@endsection
