
@extends('layouts.backend')
@section('title')
Admin
@endsection

@section('extra_css')

<style type="text/css">
  
</style>
@endsection

@section('extra_js')

@endsection

@section('content')
 
  <div class="container-fluid">
    <div class="row justify-content-center">
      @include('back.parts.message')
      <div class="col-lg-8">
        <div class="card shadow-lg border-0 rounded-lg mt-4 mb-3">
          <div class="card-header"><h4 class="text-center font-weight-normal  my-1">Edit Customer</h4></div>          
          <div class="card-body">
            <form role="form" method="post" action="{{ route('customer.update',['id'=>$customer->id]) }}" enctype="multipart/form-data">
              @csrf
              <div class="form-group row">
                <label class="col-md-3" for="name">Name <span class="text-danger">*</span></label>
                <div class="col-md-9">
                  <input  class=" form-control" name="name" value="{{$customer->name}}" placeholder="Name" type="text" autocomplete="off" required>
                  <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                </div>  
              </div>

              <div class="form-group row">
                <label class="col-md-3" for="mobile_no">Mobile No <span class="text-danger">*</span></label>
                <div class="col-md-9">
                  <input class="form-control" type="number" name="mobile_no" value="{{$customer->email}}" placeholder="Mobile No" required>
                <span class="text-danger">{{ $errors->has('mobile_no') ? $errors->first('mobile_no'):''}}</span>
                </div>  
              </div>


              <div class="form-group row">
                <label class="col-md-3" for="password">New Password <span class="text-danger">*</span></label>
                <div class="col-md-9">
                  <input class="form-control" type="password" name="password" placeholder="Password" required>
                <span class="text-danger">{{ $errors->has('password') ? $errors->first('password'):''}}</span>
                </div>  
              </div>

              <div class="form-group row">
                <label class="col-md-3" for="password">Confirm Password <span class="text-danger">*</span></label>
                <div class="col-md-9">
                  <input class="form-control" type="password" name="confirm_password" placeholder="Confirm Password" required>
                <span class="text-danger">{{ $errors->has('password') ? $errors->first('password'):''}}</span>
                </div>  
              </div>

              <div class="form-group row">
                <label class="col-md-3" for="photo">Photo <small>(200x200)</small> <span class="text-danger"></span></label>
                <div class="col-md-9">
                  <input type="file" name="photo" class="getInputFile" id="validatedCustomFile"  hidden/>
                  <label class="my_file-label" for="validatedCustomFile"><i class="fas fa-cloud-upload-alt"></i> Upload</label>
                  <span id="my-file-chosen"></span>
                  <br>
                  <label class="pt-1" id="profileLabel" for="photo">
                    <img class="getInputFileShow" src="" style="width: 100px;">
                  </label>
                  <span class="text-danger">{{ $errors->has('photo') ? $errors->first('photo'):''}}</span>
                  <img class="mt-2" width="100px" src="{{ !empty($customer->photo) ? asset('/profile/'.$customer->photo) : 'http://localhost/laravel8new/public/defaults/avatar01.png'}}">
                </div>  
              </div>

              <button type="submit" class="float-right btn btn-primary">Update</button>
            </form>
          </div>
        </div>
      </div> <!--col-5-->
    </div>  
  </div>

@endsection
