@extends('layouts.backend')
@section('title')
    Admin | Admin list
@endsection
@section('extra_css')
    <style type="text/css">
        .toggle-off.btn {
            padding-left: 0px;
        }
    </style>
@endsection

@section('content')
   
        <div class="container-fluid">
                @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="card">
                        <div class="card-header py-3  align-items-center justify-content-between">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4 class="my-2 d-flex align-items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             class="icon icon-tabler icon-tabler-award" width="28" height="28"
                                             viewBox="0 0 24 24" stroke-width="1" stroke="#ff4500" fill="none"
                                             stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <circle cx="12" cy="9" r="6"/>
                                            <polyline points="9 14.2 9 21 12 19 15 21 15 14.2"
                                                      transform="rotate(-30 12 9)"/>
                                            <polyline points="9 14.2 9 21 12 19 15 21 15 14.2"
                                                      transform="rotate(30 12 9)"/>
                                        </svg>
                                        All Account
                                    </h4>
                                </div>
                                <div class="col-md-6">
                                    <a href="{{ route('admin.create') }}" class="btn btn-primary float-right">Add New
                                        Account</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th class="text-center">Role</th>
                                        <th class="text-center">Photo</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center" style="width: 170px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($admins as $admin)
                                        <tr>
                                            <td class="text-center">{{$admin->id}}</td>
                                            <td>{{$admin->name}}</td>
                                            <td>{{$admin->email}}</td>
                                            <td class="text-center">{{$admin->role}}</td>
                                            <td class="text-center">
                                                <img width="70px"
                                                     src="{{ $admin->photo ? asset('profile/'.$admin->photo) : asset('defaults/avatar01.png')  }}" class="float-none">
                                            </td>
                                            <td class="text-center">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input changeUserStatus" id="customSwitch{{$admin->id}}" data-id="{{$admin->id}}" {{ $admin->status ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="customSwitch{{$admin->id}}"></label>
                                                </div>
                                            </td>
                                            <td class="text-center col__action__body">
                                                <a href="{{ route('admin.edit', ['id' => $admin->id])}}"
                                                   class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i class="fa fa-edit"></i></a>
                                                <a href="{{ route('admin.destroy', ['id' => $admin->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
@endsection

@section('extra_js')
<script>
    $(document).ready(function () {
        $('.changeUserStatus').change(function () {
            var status = $(this).prop('checked') == true ? 1 : 0;
            var id = $(this).data('id');
            console.log(id);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                dataType: "json",
                url: "{{ route('changeUserStatus') }}",
                data: {'status': status, 'id': id},
                success: function (data) {
                    toastr.success(data.success)
                }
            });
        });

    })
</script>
@endsection