@extends('layouts.backend')
@section('title')
    Admin | View Trash Post
@endsection

@section('extra_css')

    <style type="text/css">
        .category__filter button {
            margin-left: 10px;
        }
        .create__post svg{
            stroke: #fff !important;
            width: 18px !important;
            height: 18px !important;
            margin-right: -4px;
        }
    </style>
@endsection

@section('extra_js')

@endsection

@section('content')
    <main>
        <div class="container-fluid">
            <div class="row justify-content-center">
                @include('back.parts.message')
                <div class="col-lg-12">
                    <div class="card">
                            <div class="card-header py-3 align-items-center justify-content-between">
                                <div class="row">
                                <div class="col-md-4">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             class="icon icon-tabler icon-tabler-brand-asana" width="38" height="38"
                                             viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                             stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <rect x="4" y="4" width="6" height="6" rx="1"/>
                                            <rect x="4" y="14" width="6" height="6" rx="1"/>
                                            <rect x="14" y="14" width="6" height="6" rx="1"/>
                                            <line x1="14" y1="7" x2="20" y2="7"/>
                                            <line x1="17" y1="4" x2="17" y2="10"/>
                                        </svg>
                                        <a href="{{ route('trashpost.index') }}">Trash Post View </a>
                                    </h6>
                                </div>
                                <div class="col-md-2 d-none">
                                    <div class="search-box">
                                        <div class="input-group">
                                            <form action="" role="search" class="d-flex"
                                                  method="GET" style="margin: 0;">
                                                <input type="text" class="form-control" placeholder="Post ID, Headline or Text" name="value">
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-8 create__post float-right">
                                    <a href="{{ url()->previous() }}" class="btn btn-info float-right">Go Back</a>
                                </div>
                            </div>

                            </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <tbody>
                                    <tr>
                                        <th width="50px">ID</th>
                                        <td>{{ $trashpost->id }}</td>
                                    </tr>
                                    <tr>
                                        <th>headline</th>
                                        <td>{{ $trashpost->headline }}</td>
                                    </tr>
                                    <tr>
                                        <th>Intro</th>
                                        <td>{{ $trashpost->intro }}</td>
                                    </tr>
                                    <tr>
                                        <th>Content</th>
                                        <td>{!! $trashpost->content !!}</td>
                                    </tr>
                                    <tr>
                                        <th>Image</th>
                                        <td><img src="{{ $trashpost->image}}"/></td>
                                    </tr>
                                </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection


