@extends('layouts.backend')
@section('title')
    Admin | All Data
@endsection

@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <div class="col-md-6">
                        <h6 class="m-0 font-weight-bold text-primary">All Testimonial</h6>
                    </div>
                    <div class="col-md-6">
                        <a href="{{ route('testimonial.create') }}" class="btn btn-primary float-right">Add New</a>
                    </div>
                </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center" style="width: 70px">ID</th>
                                <th>Client Name</th>
                                <th>Designation</th>
                                <th>Order</th>
                                <th>Comment</th>
                                <th class="text-center">Image</th>
                                <th class="text-center" style="width: 170px">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $item)
                                <tr>
                                    <td class="text-center">{{$item->id}}</td>
                                    <td>{{$item->client_name}}</td>
                                    <td>{{$item->designation}}</td>
                                    <td>{{$item->order}}</td>
                                    <td>{{$item->comment}}</td>
                                    <td class="text-center"> 
                                    @if(!empty($item->image))
                                        <img class="profileImgShow" src="{{ asset('img/testimonial/'.$item->image) }}">
                                    @endif
                                    </td>
                                    <td class="text-center col__action__body">
                                        <a href="{{ route('testimonial.edit', ['id' => $item->id])}}"
                                           class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i class="fa fa-edit"></i></a>
                                        <a href="{{ route('testimonial.destroy', ['id' => $item->id])}}"
                                           onclick="return confirm('Are you sure to delete this!')"
                                           class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
            </div>
        </div>
    </div>
</div>
    
@endsection
