@extends('layouts.backend')
@section('title')
    Admin | Sub Menu Setup
@endsection

@section('extra_css')

    <style type="text/css">

    </style>
@endsection

@section('extra_js')
    <script>

    </script>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row justify-content-center">
            @include('back.parts.message')
            <div class="col-lg-4">
                <div class="card mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">Add Sub Menu</h6>
                    </div>
                    <div class="card-body">
                        <form role="form" method="post" action="{{ route('submenu.store') }}"
                              enctype="multipart/form-data">
                            @csrf

                            <div class="form-group">
                                <label for="menu">Menu <span class="text-danger">*</span></label>
                                <select class="form-control select2-single" name="menu_id" required>
                                    <option value="">--Select Menu---</option>
                                    @foreach($menus as $menu)
                                        <option value="{{$menu->id}}">{{$menu->name}}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger">{{ $errors->has('menu_id') ? $errors->first('menu_id'):''}}</span>

                            </div>

                            <div class="form-group">
                                <label for="name">Name <span class="text-danger">*</span></label>
                                <input class=" form-control" name="name" placeholder="Name" type="text"
                                       required>
                                <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>

                            </div>

                            <div class="form-group">
                                <label for="url">URL <span class="text-danger">*</span></label>
                                <input class=" form-control" name="url" placeholder="URL" type="text"
                                       required>
                                <span class="text-danger">{{ $errors->has('url') ? $errors->first('url'):''}}</span>

                            </div>

                            <div class="form-group">
                                <label for="possition">Position <span class="text-danger"></span></label>
                                <input class="form-control" type="number" id="position" name="position"
                                       placeholder="Position" autocomplete="off">
                                <span class="text-danger">{{ $errors->has('position') ? $errors->first('position'):''}}</span>

                            </div>
                            <button type="submit" class="float-right btn btn-primary">Create</button>
                        </form>
                    </div>
                </div>
            </div> <!--col-6-->

            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">All Sub Menu</h6>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th>Parent</th>
                                <th>Name</th>
                                <th>URL</th>
                                <th class="text-center">Position</th>
                                <th class="col__action__body">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $items = \App\Models\SubMenu::orderby('menu_id', 'ASC')->orderBy('position', 'ASC')->Paginate(30); ?>
                            @foreach($items as $row)
                                <tr>
                                    <td>{{$row->menu->name}}</td>
                                    <td>{{$row->name}}</td>
                                    <td>{{$row->url}}</td>
                                    <td class="text-center">{{$row->position}}</td>
                                    <td class="col__action__body">
                                        <a title="edit" href="{{ route('submenu.edit', ['id' => $row->id])}}"
                                           class="btn btn-info btn-sm">Edit</a>
                                        <div style="display: inline-block;">
                                            <form method="POST"
                                                  action="{{ route('submenu.delete', ['id' => $row->id])}}">
                                                @csrf
                                                <input name="_method" type="hidden" value="DELETE">
                                                <button type="submit"
                                                        class="btn btn-danger btn-sm delete_confirm"
                                                        data-toggle="tooltip" title='Delete'>Delete</button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        <div class="pagination px-3 pb-2">
                            {{$items->links()}}
                        </div>
                    </div>
                </div>
            </div> <!--col-6-->

        </div>
    </div>
@endsection
