@extends('layouts.backend')
@section('title')
    Admin | Index
@endsection

@section('extra_css')

    <style type="text/css">

    </style>
@endsection

@section('extra_js')

@endsection

@section('content')
    <main>
        <div class="container-fluid">
            <div class="row justify-content-center">
                @include('back.parts.message')
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">Edit Sub Category</h6>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post"
                                  action="{{ route('sub_category.update',['id'=>$sub_cat->id]) }}">
                                @csrf
                                <div class="form-group">
                                    <label for="name">Category <span
                                                class="text-danger">*</span></label>
                                    <select class="form-control select2-single" name="category_id" required style="width: 100%">
                                        <option selected
                                                value="{{$sub_cat->category_id}}">{{$sub_cat->category->name}}</option>
                                        @foreach($categories as $category)
                                            <option value="{{$category->id}}">{{$category->name}}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger">{{ $errors->has('category_id') ? $errors->first('category_id'):''}}</span>
                                </div>
                                <div class="form-group ">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                    <input class=" form-control" name="name" value="{{ $sub_cat->name }}"
                                           placeholder="Name" type="text" required autocomplete="off">
                                    <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                                </div>

                                <div class="form-group ">
                                    <label for="slug">Slug <span class="text-danger"></span></label>
                                    <input class=" form-control" name="slug" value="{{ $sub_cat->slug }}"
                                           placeholder="Slug" type="text" autocomplete="off">
                                    <span class="text-danger">{{ $errors->has('slug') ? $errors->first('slug'):''}}</span>
                                </div>

                                <div class="form-group ">
                                    <label for="possition">Position <span
                                                class="text-danger"></span></label>
                                    <input class="form-control" type="number" value="{{ $sub_cat->position }}"
                                           name="position" id="position" placeholder="Position" min="0">
                                    <span class="text-danger">{{ $errors->has('position') ? $errors->first('position'):''}}</span>
                                </div>
                                <button type="submit" class="float-right btn btn-success">Update</button>
                                <a href="{{route('sub_category.create')}}" class="float-right btn btn-danger mr-2">Cancel</a>
                            </form>
                        </div>
                    </div>
                </div> <!--col-5-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">All Sub Category</h6>
                        </div>
                        <div class="table-responsive">
                            <table class="table align-items-center table-flush">
                                <thead class="thead-light">
                                <tr>
                                    <th class="text-center col__id">ID</th>
                                    <th>Category</th>
                                    <th>Name</th>
                                    <th class="text-center">Position</th>
                                    <th class="col__action__body">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $items = \App\Models\SubCategory::orderBy('category_id', 'asc')->orderBy('position', 'asc')->Paginate(30); ?>
                                @foreach($items as $row)
                                    <tr>
                                        <td class="text-center">{{$row->id}}</td>
                                        <td>{{$row->category->name}}</td>
                                        <td>{{$row->name}}</td>
                                        <td class="text-center">{{$row->position}}</td>
                                        <td class="col__action__body">
                                            <a title="view" target="_blank"
                                               href="{{url('/').'/'.$row->parentCategory->slug.'/'.$row->category->slug.'/'.$row->slug}}"
                                               class="btn btn-success btn-sm">View</a>
                                            <a title="edit" href="{{ route('sub_category.edit', ['id' => $row->id])}}"
                                               class="btn btn-info btn-sm">Edit</a>

                                            <div style="display: inline-block;">
                                                <form method="POST"
                                                      action="{{ route('sub_category.destroy', ['id' => $row->id])}}">
                                                    @csrf
                                                    <input name="_method" type="hidden" value="DELETE">
                                                    <button type="submit"
                                                            class="btn btn-danger btn-sm delete_confirm"
                                                            data-toggle="tooltip" title='Delete'>Delete</button>
                                                </form>
                                            </div>

                                        </td>
                                    </tr>
                                @endforeach

                                </tbody>
                            </table>
                            <div class="pagination px-3 pb-2">
                                {{$items->links()}}
                            </div>
                        </div>
                    </div>
                </div> <!--col-6-->

            </div>
        </div>
    </main>
@endsection
