@extends('layouts.backend')
@section('title')
    Admin | All Data
@endsection

@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <div class="col-md-6">
                        <h6 class="m-0 font-weight-bold text-primary">All Project</h6>
                    </div>
                    <div class="col-md-6">
                        <a href="{{ route('service.create') }}" class="btn btn-primary float-right">Add New</a>
                    </div>
                </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center col__id">ID</th>
                                <th>Short Intro</th>
                                <th class="text-center">Image</th>
                                <th class="col__action__body">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $item)
                                <tr>
                                    <td class="text-center">{{$item->position}}</td>
                                    <td>{{$item->short_intro}}</td>
                                    <td class="text-center">
                                        @if(!empty($item->image))
                                        <img class="profileImgShow" src="{{ asset('img/service/'.$item->image) }}">
                                        @endif
                                    </td>
                                    <td class="col__action__body">
                                        <a href="{{ route('service.edit', ['id' => $item->id])}}"
                                           class="btn btn-info btn-sm">Edit</a>
                                        <a href="{{ route('service.destroy', ['id' => $item->id])}}"
                                           onclick="return confirm('Are you sure to delete this!')"
                                           class="btn btn-danger btn-sm">Delete</a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
            </div>
        </div>
    </div>
</div>
    
@endsection
