@extends('layouts.backend')
@section('title')
    Admin | Staff role page
@endsection

@section('extra_css')

    <style type="text/css">

    </style>
@endsection

@section('extra_js')

@endsection

@section('content')
   
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4 class="my-2">All Roles</h4>
                                </div>
                                <div class="col-md-6">
                                    <a href="{{ route('role.create') }}" class="btn btn-primary float-right">Add New
                                        Role</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Name</th>
                                        <th class="text-center" style="width: 170px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($roles as $role)
                                        <tr>
                                            <td class="text-center">{{$role->id}}</td>
                                            <td>{{$role->name}}</td>
                                            <td class="text-center col__action__body">
                                                <a href="{{ route('role.edit', ['id' => $role->id])}}"
                                                   class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i class="fa fa-edit"></i></a>
                                                <a href="{{ route('role.destroy', ['id' => $role->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
@endsection
