@extends('layouts.backend')
@section('title')
    Admin
@endsection

@section('extra_css')
    <style type="text/css">
        .toggle-off.btn {
            padding-left: 0px;
        }

        .label-text {
            font-family: serif;
            line-height: 1.5;
        }

    </style>
@endsection

@section('extra_js')

@endsection

@section('content')
   
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card shadow-lg border-0 rounded-lg mt-4 mb-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4 class="my-2">Role Information</h4>
                                </div>
                                <div class="col-md-6">
                                    <a href="{{ route('role.index') }}" class="btn btn-primary float-right">View All
                                        Role</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post" action="{{ route('role.store') }}">
                                @csrf
                                <div class="form-group row">
                                    <label class="col-md-3" for="name">Name <span class="text-danger">*</span></label>
                                    <div class="col-md-9">
                                        <input class=" form-control" name="name" placeholder="Name" type="text"
                                               autocomplete="off" required>
                                        <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                                    </div>
                                </div>
                                <div class="card-header">
                                    <h5 class="mb-0 ">Permissions</h5>
                                </div>
                                <div class="form-group row mt-2 justify-content-center">
                                    <div class="col-md-8 ">
                                        <div class="row mt-1 mb-1">
                                            <label class="col-md-10 label-text">Website Setup</label>
                                            <div class="col-md-2">
                                                <label class="switch">
                                                    <input class="permissions" name="permissions[]" type="checkbox"
                                                           value="1">
                                                    <span class="slider round"></span>
                                                </label>
                                            </div>
                                        </div>

                                        <div class="row mt-1 mb-1">
                                            <label class="col-md-10 label-text">Products</label>
                                            <div class="col-md-2">
                                                <label class="switch">
                                                    <input class="permissions" name="permissions[]" type="checkbox"
                                                           value="2">
                                                    <span class="slider round"></span>
                                                </label>
                                            </div>
                                        </div>

                                        <div class="row mt-1 mb-1">
                                            <label class="col-md-10 label-text">Shipping Cost</label>
                                            <div class="col-md-2">
                                                <label class="switch">
                                                    <input class="permissions" name="permissions[]" type="checkbox"
                                                           value="3">
                                                    <span class="slider round"></span>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row mt-1 mb-1">
                                            <label class="col-md-10 label-text">Sales</label>
                                            <div class="col-md-2">
                                                <label class="switch">
                                                    <input class="permissions" name="permissions[]" type="checkbox"
                                                           value="4">
                                                    <span class="slider round"></span>
                                                </label>
                                            </div>
                                        </div>

                                        <div class="row mt-1 mb-1">
                                            <label class="col-md-10 label-text">Marketing</label>
                                            <div class="col-md-2">
                                                <label class="switch">
                                                    <input class="permissions" name="permissions[]" type="checkbox"
                                                           value="5">
                                                    <span class="slider round"></span>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row mt-1 mb-1">
                                            <label class="col-md-10 label-text">Reports</label>
                                            <div class="col-md-2">
                                                <label class="switch">
                                                    <input class="permissions" name="permissions[]" type="checkbox"
                                                           value="6">
                                                    <span class="slider round"></span>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row mt-1 mb-1">
                                            <label class="col-md-10 label-text">Customer</label>
                                            <div class="col-md-2">
                                                <label class="switch">
                                                    <input class="permissions" name="permissions[]" type="checkbox"
                                                           value="7">
                                                    <span class="slider round"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="float-right btn btn-primary">Save</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-5-->
            </div>
        </div>
    
@endsection
