@extends('layouts.backend')
@section('title')
    Admin | Sales Report
@endsection

@section('extra_css')
<link rel="stylesheet" type="text/css" href="{{asset('/assets/vendor/datepicker/daterangepicker.css')}}"/>
@endsection
@section('extra_js')
<script type="text/javascript" src="{{asset('/assets/vendor/datepicker/moment.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/vendor/datepicker/daterangepicker.min.js')}}"></script>
<script>
    $(function () {
        $('input[name="date"]').daterangepicker({
            opens: 'left'
        }, function (start, end, label) {
            console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
        });
    });
</script>
@endsection

@section('content')

        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-10 m-auto">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3 p-3">
                        <div class="card-header">
                            <div class="row d-flex">
                                <div class="col-md-6 mb-2">
                                    <h4 class="my-2 d-flex align-items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             class="icon icon-tabler icon-tabler-database" width="28" height="28"
                                             viewBox="0 0 24 24" stroke-width="1" stroke="#ff4500" fill="none"
                                             stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <ellipse cx="12" cy="6" rx="8" ry="3"></ellipse>
                                            <path d="M4 6v6a8 3 0 0 0 16 0v-6"/>
                                            <path d="M4 12v6a8 3 0 0 0 16 0v-6"/>
                                        </svg>
                                        Sales Report
                                    </h4>
                                </div>
                                <div class="col-md-3 mb-2">
                                    <div class="search-box">
                                        <form action="{{ route('sales.report.search')}}" role="search"
                                              class="d-flex" method="GET" style="margin: 0;">
                                            <input type="text" class="form-control"
                                                   placeholder="Type id or name and hit enter" name="search" required=""
                                                   style="height: 44px">
                                        </form>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-2">
                                    <div class="input-group">
                                        <form action="{{ route('sales.report.date')}}" role="search" class="d-flex"
                                              method="GET" style="margin: 0;">
                                            <input type="text" class="form-control" placeholder="date" name="date"
                                                   required="" style="height: 44px">
                                            <button class="btn px-4 ms-3"
                                                    style="background: #0abb75;border: none;color: white; height: 44px; margin-left: -5px"
                                                    type="submit">Search
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Product Name</th>
                                        <th class="text-center">Total Sale</th>
                                        <th class="text-center">Total Price</th>
                                        <th class="text-center">Total Discount</th>
                                        <th class="text-center">Sale Amount</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $productID = [];

                                    foreach ($orders as $row) {
                                        $productID[] = $row['product_id'];
                                    }

                                    $uniqueProductID = array_unique($productID);
                                    $uniqueProductVal = array_values($uniqueProductID);

                                    foreach ($uniqueProductID as $item) {
                                        echo "<tr>";
                                        echo "<td class='text-center'>" . $item . "</td>";
                                        echo "<td>" . App\Models\Order::where('product_id', $item)->first()->product_name . "</td>";
                                        $totalQty = App\Models\Order::where('product_id', $item)->pluck('product_quantity');
                                        $totalQty = $totalQty->sum();
                                        echo "<td class='text-center'>" . $totalQty . "</td>";

                                        $regularPrice = App\Models\Order::where([['product_id', $item], ['regular_price', '!=', null]])->first()->regular_price;
                                        echo "<td class='text-center'>" . $regularPrice * $totalQty . "</td>";

                                        $total_discount = App\Models\Order::where('product_id', $item)->pluck('total_discount');
                                        $total_discount = $total_discount->sum();
                                        echo "<td class='text-center'>" . $total_discount . "</td>";

                                        $totalPrice = App\Models\Order::where('product_id', $item)->pluck('total_price');
                                        $totalPrice = $totalPrice->sum();
                                        echo "<td class='text-center'>" . $totalPrice . "</td>";
                                        echo "</tr>";

                                    }
                                    ?>

                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td class='text-center' colspan="2"><b>Grand Total</b></td>
                                        <?php

                                        $grand_total_sale = App\Models\Order::orderBy('id', 'desc')->pluck('total_price');
                                        $grand_total_sale = $grand_total_sale->sum();

                                        $grand_total_discount = App\Models\Order::orderBy('id', 'desc')->pluck('total_discount');
                                        $grand_total_discount = $grand_total_discount->sum();

                                        $grand_total_qty = App\Models\Order::orderBy('id', 'desc')->pluck('product_quantity');
                                        $grand_total_qty = $grand_total_qty->sum();
                                        echo "<td class='text-center'><b>" . $grand_total_qty . "</b></td>";


                                        echo "<td class='text-center'><b>" . $grand_total_sale + $grand_total_discount . "</b></td>";


                                        echo "<td class='text-center'><b>" . $grand_total_discount . "</b></td>";


                                        echo "<td class='text-center'><b>" . $grand_total_sale . "</b></td>";
                                        ?>
                                    </tr>
                                    </tfoot>
                                </table>
                                <div class=" mt-1">
                                    {{$orders->links()}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

@endsection
