@extends('layouts.backend')
@section('title')
    Admin | Inventory
@endsection

@section('extra_css')

    <style type="text/css">

    </style>
@endsection

@section('extra_js')
    <script>
        $(document).ready(function () {
            $('.auto-submit').on('change', function () {
                $('#filter-form').submit();
            });
        })
    </script>
@endsection

@section('content')
   
        <div class="container-fluid">
            <div class="row justify-content-center">
                @include('back.parts.message')
                <div class="col-lg-8 m-auto">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3 p-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-4">
                                    <h4 class=" font-weight-light my-2 float-left">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             class="icon icon-tabler icon-tabler-database" width="28" height="28"
                                             viewBox="0 0 24 24" stroke-width="1" stroke="#ff4500" fill="none"
                                             stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <ellipse cx="12" cy="6" rx="8" ry="3"></ellipse>
                                            <path d="M4 6v6a8 3 0 0 0 16 0v-6"/>
                                            <path d="M4 12v6a8 3 0 0 0 16 0v-6"/>
                                        </svg>
                                        Inventory
                                    </h4>
                                </div>
                                <div class="col-md-4">
                                    <div class="search-box">
                                            <form action="{{ route('inventory.search')}}" role="search" class="d-flex"
                                                  method="GET" style="margin: 0;">
                                                <input type="text" class="form-control"
                                                       placeholder="Type id or name & hit enter" name="search" required=""
                                                       style="height: 44px">
                                            </form>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="search-box">
                                        <div class="input-group">
                                            <form action="{{ route('inventory.sorting')}}" role="search" class="d-flex"
                                                  id="filter-form" method="GET" style="margin: 0;">
                                                <select class="form-control auto-submit" name="stock">
                                                    <option value="">Sort By</option>
                                                    <option value="desc">Stock (High to Low)</option>
                                                    <option value="asc">Stock (Low to High)</option>
                                                </select>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Product Name</th>
                                        <th class="text-center">Total Qty</th>
                                        <th class="text-center">Total Sale</th>
                                        <th class="text-center">Available Stock</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($products as $row)
                                        <?php
                                        $total_sale = 0;
                                        $sales = App\Models\Order::where('product_id', $row->id)->get();
                                        foreach ($sales as $sale) {
                                            if ($row->id == $sale->product_id) {
                                                $total_sale += $sale->product_quantity;
                                            }
                                        }
                                        ?>
                                        <tr>
                                            <td>{{$row->id}}</td>
                                            <td>{{$row->product_name}}</td>
                                            <td class="text-center">{{$row->quantity+$total_sale}}</td>
                                            <td class="text-center">{{$total_sale}}</td>
                                            <td class="text-center col__action__body">
                                                @if($row->quantity > 0)
                                                    <span>{{ $row->quantity }}</span>
                                                @endif
                                                @if($row->quantity < 10 && $row->quantity > 0)
                                                    <span class="badge badge-warning">Low</span>
                                                @elseif($row->quantity == 0)
                                                    <span class="badge badge-danger">Empty</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                <div class=" mt-1">
                                    {{$products->links()}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
@endsection
