@extends('layouts.backend')
@section('title')
Admin | Product Quick Edit
@endsection

@section('extra_css')
@endsection



@section('content')
<main>

  <form name="form" id="product_create_form" method="post" action="{{ route('product.quick.update', ['id'=>$product->id]) }}">
  @csrf
    <div class="container-fluid">
      <div class="row justify-content-center">
        @include('back.parts.message')
        
        <div class="col-lg-8">
          
            <div class="card shadow-lg border-0 rounded-lg mt-4 mb-3">
                <div class="card-header"><h4 class="font-weight-normal my-1">Price Update</h4></div>
                <div class="card-body">

                    <div class="form-group row">
                        <label class="col-md-3" for="number">Unit price<span class="text-danger">*</span></label>
                        <div class="col-md-9">
                            <input type="number" name="unit_price" min="0" value="{{$product->unit_price}}"  class="form-control" required>
                            <span class="text-danger">{{ $errors->has('unit_price') ? $errors->first('unit_price'):''}}</span>
                        </div>
                    </div>


                    <div class="form-group row">
                        <label class="col-md-3" for="discount_type">Discount Type<span class="text-danger"></span></label>
                        <div class="col-md-9">
                            <select class="form-control" name="discount_type">
                                <option value="{{$product->discount_type}}">{{$product->discount_type}}</option>
                                <option value="">No Discount</option>
                                <option value="flat">Flat</option>
                                <option value="percent">Percent</option>
                            </select>
                            <span class="text-danger">{{ $errors->has('discount_type') ? $errors->first('discount_type'):''}}</span>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-md-3" for="discount">discount<span class="text-danger"></span></label>
                        <div class="col-md-9">
                            <input type="number" name="discount" min="0" value="{{$product->discount}}"  class="form-control" >
                            <span class="text-danger">{{ $errors->has('discount') ? $errors->first('discount'):''}}</span>
                        </div>
                    </div>

                   <div class="col-lg-12">
          <div class="float-right mb-3">
            <button type="submit" class="float-right btn btn-primary">Quick Update</button>
          </div>
        </div>
                </div>
            </div> <!--card-->
        </div> <!--col-4-->

        
        
      </div>  
    </div>
  </form>
</main>

@endsection

@section('extra_js')

@endsection
