@extends('layouts.backend')
@section('title')
    Admin | All Products
@endsection

@section('extra_css')

@endsection

@section('extra_js')
    <script>


    </script>
@endsection

@section('content')
    <div class="container-fluid">
        @include('back.parts.message')
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header py-3 align-items-center justify-content-between">
                        <div class="row">
                            <div class="col-md-4">
                                <h6 class="m-0 font-weight-bold text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                         class="icon icon-tabler icon-tabler-brand-asana" width="28" height="28"
                                         viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                         stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <rect x="4" y="4" width="6" height="6" rx="1"/>
                                        <rect x="4" y="14" width="6" height="6" rx="1"/>
                                        <rect x="14" y="14" width="6" height="6" rx="1"/>
                                        <line x1="14" y1="7" x2="20" y2="7"/>
                                        <line x1="17" y1="4" x2="17" y2="10"/>
                                    </svg>
                                    All Product
                                </h6>
                            </div>
                            <div class="col-md-6">
                                <div class="search-box d-none">
                                    <div class="input-group">
                                        <form action="{{ route('post.search') }}" role="search" class="d-flex"
                                              method="GET" style="margin: 0;">
                                            <input type="text" class="form-control"
                                                   placeholder="product ID, Headline or Text" name="value">
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2 create__post float-right">
                                <a href="{{ route('product.create') }}" class="btn btn-primary float-right">
                                    Add New Product</a>
                            </div>
                        </div>

                    </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center col__id">ID</th>
                                <th>Name</th>
                                <th class="text-center">Image</th>
                                <th class="text-center">Category</th>
                                <th class="text-center">Publisher</th>
                                <th class="text-center">Time</th>
                                <th class="col__action__body">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($products as $product)
                                <tr>
                                    <td class="text-center">{{$product->id}}</td>
                                    <td class="">
                                        {{ Str::limit($product->name, 55) }}
                                    </td>
                                    <td class="text-center"><img width="50px"
                                                                 src="{{asset('/img/product/feature').'/'.$product->feature_image}}">
                                    </td>
                                    <td class="text-center">
                                        @if(!empty($product->category_id))
                                            {{$product->category->name}}
                                        @endif
                                    </td>
                                    <td class="text-center">{{  $product->User->name }}</td>
                                    <td class="text-center">{{ Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $product->created_at)->format('H:i/d-m') }}</td>

                                    <td class="col__action__body">
                                        <a title="view" target="_blank" href="{{product_url($product)}}"
                                           class="btn btn-success btn-sm">View</a>
                                        <a title="edit" href="{{ route('product.edit', ['id' => $product->id])}}"
                                           class="btn btn-info btn-sm">Edit</a>
                                        <a title="delete" href="{{ route('product.destroy', ['id' => $product->id])}}"
                                           onclick="return confirm('Are you sure to delete this!')"
                                           class="btn btn-danger btn-sm">Delete</a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        <div class="pagination px-3 pb-2">
                            {{$products->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


