@extends('layouts.backend')
@section('title')
    Admin | Product Filter
@endsection

@section('extra_css')

    <style type="text/css">
        .btn-sm.btn-icon {
            padding: 8px;
            width: 35px;
            height: 35px;
        }

        .btn-circle {
            border-radius: 50em;
        }

        .btn-soft-success {
            background-color: rgba(10, 187, 117, .15);
            color: #0abb75;
        }

        .btn-soft-success:hover {
            background-color: #0abb75;
            color: #fff;
        }

        .btn-soft-primary {
            background-color: rgba(55, 125, 255, .15);
            color: #377dff;
        }

        .btn-soft-primary:hover {
            background-color: #377dff;
            color: #fff;
        }

        .btn-soft-warning {
            background-color: rgba(255, 197, 25, .15);
            color: #ffc519;
        }

        .btn-soft-warning:hover {
            background-color: #ffc519;
            color: #fff;
        }

        .btn-soft-danger {
            background-color: rgba(239, 72, 106, .15);
            color: #ef486a;
        }

        .btn-soft-danger:hover {
            background-color: #ef486a;
            color: #fff;
        }

        .product__image img {
            border-radius: 5px;
        }
    </style>
@endsection

@section('extra_js')
    <script>

        $(document).ready(function () {
            $('.auto-submit').on('change', function () {
                $('#filter-form').submit();
            });
        })

        $(document).ready(function () {

            $('.changeTodaysDeal').change(function () {
                var todays_Deal = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).data('id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "{{ route('changeTodaysDeal') }}",
                    data: {'todays_Deal': todays_Deal, 'id': id},
                    success: function (data) {
                        toastr.success(data.success)
                    }
                });
            });


            $('.changePublicationStatus').change(function () {
                var publication_status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).data('id');
                console.log(id);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "{{ route('changePublicationStatus') }}",
                    data: {'publication_status': publication_status, 'id': id},
                    success: function (data) {
                        toastr.success(data.success)
                    }
                });
            });

            $('.changeFeaturedStatus').change(function () {
                var featured_status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).data('id');
                console.log(id);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "{{ route('changeFeaturedStatus') }}",
                    data: {'feature': featured_status, 'id': id},
                    success: function (data) {
                        toastr.success(data.success)
                    }
                });
            });
        })
    </script>
@endsection

@section('content')
    <main>
        <div class="container-fluid">
            <div class="row justify-content-center">
                @include('back.parts.message')
                <div class="col-lg-12">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header">
                            <div class="row d-flex justify-content-between">
                                <div class="col-md-2 col-lg-2">
                                    <h5 class="my-2 d-flex align-items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             class="icon icon-tabler icon-tabler-brand-asana" width="25" height="25"
                                             viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                             stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <rect x="4" y="4" width="6" height="6" rx="1"/>
                                            <rect x="4" y="14" width="6" height="6" rx="1"/>
                                            <rect x="14" y="14" width="6" height="6" rx="1"/>
                                            <line x1="14" y1="7" x2="20" y2="7"/>
                                            <line x1="17" y1="4" x2="17" y2="10"/>
                                        </svg>
                                        All Products
                                    </h5>
                                </div>
                                <div class="col-md-2 col-lg-2">
                                    <div class="search-box">
                                        <div class="input-group">
                                            <form action="{{ route('admin.product.search')}}" role="search"
                                                  class="d-flex" method="GET" style="margin: 0;">
                                                <input type="text" class="form-control"
                                                       placeholder="Type & Hit Enter (ID, Name)" name="search" required
                                                       style="height: 44px">
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-6">
                                    <form id="filter-form" method="get" action="{{ route('products.filter')}}">
                                        <div class="row d-flex">
                                            <div class="col-md-4 col-lg-4">
                                                <div class="form-group">
                                                    <select class="form-select form-control auto-submit" name="publication_id">
                                                        <option value="" selected disabled>Select Publication</option>
                                                        <?php $publications = publications(); ?>
                                                        @foreach($publications as $pubItem)
                                                            <option @if(!empty($publication_id)) @if($publication_id == $pubItem->id) selected
                                                            @endif @endif value="{{$pubItem->id}}">{{$pubItem->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-5 col-lg-5">
                                                <div class="form-group">
                                                    <select class="form-select form-control auto-submit"
                                                            name="category_id">
                                                        <option value="" selected disabled>Select Category</option>
                                                        @foreach(\App\Models\Category::all() as $item)
                                                            <option @if(!empty($category_id)) @if($category_id == $item->id) selected
                                                            @endif @endif value="{{$item->id}}">{{$item->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-lg-3">
                                                <div class="form-group">
                                                    <select name="sort_by"
                                                            class="form-control form-select me-2 auto-submit">
                                                        <option value="">Sort By</option>
                                                        <option @if(!empty($sort_by)) @if($sort_by == 'lowest_price') selected
                                                            @endif @endif  value="lowest_price">Price (Low to High)</option>
                                                        <option @if(!empty($sort_by)) @if($sort_by == 'highest_price') selected
                                                            @endif @endif value="highest_price">Price (High to Low)</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-2 col-lg-2 float-right">
                                    <a href="{{ route('product.create') }}"
                                       class="btn btn-primary py-2">Add New Product</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                    <tr>
                                        <th class="text-center col__id" style="width: 80px">ID</th>
                                        <th style="min-width: 250px">Name</th>
                                        <th class="text-center">Price</th>
                                        <th class="text-center" style="width: 100px">Author/Pub</th>
                                        <th class="text-center" style="width: 100px">Category</th>
                                        <th class="text-center">Stock</th>
                                        <th class="text-center">T.Deal</th>
                                        <th class="text-center">Published</th>
                                        <th class="text-center">Featured</th>
                                        <th class="text-center col__action" style="width: 180px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($products as $product)
                                        <tr>
                                            <td class="text-center">{{$product->id}}</td>
                                            <td class="product__name">
                                                <img src="{{ $product->feature_image ? asset('/img/product/feature/'.$product->feature_image): asset('/defaults/avatar02.png')  }}"
                                                     width="50px" class="size-50px img-fit">
                                                <a href="{{ product_url($product) }}" target="_blank">
                                                    <p>{{ Str::limit($product->product_name, 55) }}</p></a>
                                            </td>
                                            <td class="text-center">{{$product->unit_price}}</td>
                                            <td class="text-center author">
                                                @foreach($product->authors->all() as $author)
                                                    <a target="_blank" title="{{$author->name}}" href="{{author_url($author->id)}}"><span class="custom__badge mb-2">{{Str::limit($author->name, 15)}}</span></a>
                                                @endforeach
                                                @foreach($product->publications->all() as $publication)
                                                    <a target="_blank" title="{{$publication->name}}" href="{{publication_url($publication->id)}}"><span class="custom__badge2">{{Str::limit($publication->name, 18)}}</span></a>
                                                @endforeach
                                            </td>
                                            <td class="text-center category">
                                                @foreach($product->categories->all() as $cat)
                                                    <a target="_blank" title="{{$cat->name}}" href="{{category_url($cat->id)}}"><span class="custom__badge">{{Str::limit($cat->name, 18)}}</span></a>
                                                @endforeach
                                            </td>
                                            <td class="text-center">
                                                @if($product->quantity > 0)
                                                    <span>{{ $product->quantity }}</span>
                                                @endif
                                                @if($product->quantity < 10 && $product->quantity > 0)
                                                    <span class="badge bg-danger">Low</span>
                                                @elseif($product->quantity == 0)
                                                    <span class="badge bg-danger">Empty</span>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                <label class="switch">
                                                    <input class="changeTodaysDeal" type="checkbox"
                                                           data-id="{{$product->id}}" {{ $product->todays_Deal ? 'checked' : '' }}>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                            <td class="text-center">
                                                <label class="switch">
                                                    <input class="changePublicationStatus" type="checkbox"
                                                           data-id="{{$product->id}}" {{ $product->publication_status ? 'checked' : '' }}>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                            <td class="text-center">
                                                <label class="switch">
                                                    <input class="changeFeaturedStatus" type="checkbox"
                                                           data-id="{{$product->id}}" {{ $product->feature ? 'checked' : '' }}>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                            <td class="text-center col__action__body">
                                                <a title="view" target="_blank" href="{{ product_url($product) }}"
                                                   class="btn btn-soft-success btn-icon btn-circle btn-sm"><i
                                                            class="fa fa-eye"></i></a>
                                                <a title="edit"
                                                   href="{{ route('product.edit', ['id' => $product->id])}}"
                                                   class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i
                                                            class="fa fa-edit"></i></a>
                                                <a title="duplicate"
                                                   href="{{ route('product.duplicate', ['id' => $product->id])}}"
                                                   class="btn btn-soft-warning btn-icon btn-circle btn-sm"><i
                                                            class="fa fa-clone"></i></a>
                                                <a title="delete"
                                                   href="{{ route('product.destroy', ['id' => $product->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i
                                                            class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>

                                {{ $products->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection


