@extends('layouts.backend')
@section('title')
    Admin | Popup ads setting
@endsection

@section('extra_css')

@endsection

@section('extra_js')

@endsection

@section('content')
   
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">Add Popup Adv.</h6>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post" action="{{ route('popup.store') }}"
                                  enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                        <input class="form-control" name="name" placeholder="Name" type="text"
                                               autocomplete="off" maxlength="95" required>
                                        <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="link">Link <span class="text-danger"></span></label>
                                        <input class="form-control" name="link" placeholder="Link" type="text"
                                               autocomplete="off">
                                        <span class="text-danger">{{ $errors->has('link') ? $errors->first('link'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="position">Visible for</label>
                                        <select name="position" id="position" class="form-control">
                                            <option value="home">Home Page</option>
                                            <option value="single">Single Page</option>
                                        </select>
                                        <span class="text-danger">{{ $errors->has('position') ? $errors->first('position'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="status">Status</label>
                                        <select name="status" id="status" class="form-control">
                                            <option value="1">Yes</option>
                                            <option value="0">No</option>
                                        </select>
                                        <span class="text-danger">{{ $errors->has('status') ? $errors->first('status'):''}}</span>
                                </div>

                                <div class="form-group">
                                     <label for="image">Image<small>(740x740)</small><span
                                                class="text-danger">*</span></label>
                                     <div class="custom-file">
                                        <input type="file" class="custom-file-input profile-img-input"  id="image" name="image">
                                        <label class="custom-file-label" for="customFile">Choose file</label>
                                     </div>
                                     <span class="text-danger">{{ $errors->has('image') ? $errors->first('image'):''}}</span>
                                     <div class="pt-1" id="profileLabel" for="image">
                                        <img class="profileImgShow" src="{{ asset('defaults/default3.png')}}">
                                     </div>
                                </div>
                                
                                <button type="submit" class="float-right btn btn-primary">Create</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Popup Adv.</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center">Name</th>
                                        <th class="text-center">Visible for</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center">Image</th>
                                        <th class="text-center" style="width: 170px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach(App\Models\Popup::orderBy('id','desc')->get() as $key=> $row)
                                        <tr>
                                            <td class="text-center">{{$row->name}}</td>
                                            <td class="text-center">{{$row->position}}</td>
                                            <td class="text-center">{{$row->status ?'active':'inactive'}}</td>
                                            <td class="text-center"><img width="100px"
                                                                         src="{{ asset('img/popup/'.$row->image)}}" class="float-none">
                                            </td>
                                            <td class="text-center col__action__body">
                                                <a href="{{ route('popup.edit', ['id' => $row->id])}}"
                                                   class="btn btn-soft-success btn-icon btn-circle btn-sm"><i class="fa fa-edit"></i></a>
                                                <a href="{{ route('popup.destroy', ['id' => $row->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    
@endsection
