@extends('layouts.backend')

@section('title')
admin | photo edit
@endsection

@section('extra_css')
<!--<link rel="stylesheet" href="{{ asset('assets/css/custom.min.css') }}">-->
<link rel="stylesheet" href="{{ asset('assets/vendors/google-code-prettify/bin/prettify.min.css') }}">
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css" rel="stylesheet"/>
<link rel="stylesheet" type="text/css"
href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/tag-it/2.0/css/jquery.tagit.min.css" rel="stylesheet"
type="text/css">
<style>
    .btn-height{
            height: 43px;
            box-shadow: unset !important;
            border-top-left-radius: 0;
            border-bottom-left-radius: 0;
            color: white !important;
        }
        .input-group-btn .btn-height{
            cursor:pointer;
        }
    #plusBtn{
        margin-top: 32px;
        height: 44px;
    }
    .removeBtn{
        margin-top: 32px;
        height: 44px;
    }
</style>
@endsection

@section('content')
<main>
   <div class="container">
      <div class="row justify-content-center">
         <div class="col-lg-12">
            <div class="card shadow-lg border-0 rounded-lg mt-5 mb-5">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
            <h5>Photo Gallery</h5> 
            <a href="{{ route('photo.create') }}" class="btn btn-sm btn-primary">Add New</a>
        </div>
        <div class="card-body">
            <div class="row">
         <div class="col-lg-12">
            <form role="form" method="post" action="{{ route('photo.update',['id'=>$photo->id]) }}" >

            {{ csrf_field() }}

            <div class="form-group">
                <label class="mb-1" for="title">Title</label>
                <input type="text" id="title" name="title" value="{{$photo->title}}" maxlenght="200" class="form-control" required="required">
            </div>
            <div class="form-group">
                <label>feature image</label>
                <div class="input-group">
                    <input id="image" class="form-control" type="text" name="featured_image" maxlenght="250" value="{{$photo->featured_image}}">
                    <span class="input-group-btn"> <a id="feature_lfm" data-input="image" data-preview="holder" class="btn btn-primary btn-height"> <i class="fa fa-image"></i> Choose </a> </span>
                </div>
            </div>

            @if(!empty($photobody))
            <div class="row">
                <div class="col-md-10">
                    <div class="form-group">
                        <label>Thumbnail</label>
                        <div class="input-group">
                            <input id="thumbnail" class="form-control" type="text" name="thumbnail[]" maxlenght="250" value="{{$photobody->thumbnail}}">
                            <span class="input-group-btn"> <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary btn-height"> <i class="fa fa-image"></i> Choose </a> </span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Content</label>
                        <div class="input-group">
                            <textarea class="form-control" id="caption" name="caption[]" style="height: auto !important;" rows="5">{{$photobody->caption}}</textarea>
                        </div>
                    </div>
                </div>

                <div class="col-md-2">
                    <button id="plusBtn" class="btn btn-primary">+</button>
                </div>
            </div>
            @endif


            @if(!empty($photobodies))
            @foreach($photobodies as $body)
            <div class="containerbox">
                <div class="row">
                    <div class="col-md-10">
                        <div class="form-group">
                            <label>Thumbnail</label>
                            <div class="input-group">
                                <input id="thumbnail{{$body->id}}" class="form-control" type="text" name="thumbnail[]" value="{{$body->thumbnail}}">
                                <span class="input-group-btn"> <a id="lfmEdit{{$body->id}}" data-input="thumbnail{{$body->id}}" data-preview="holder" class="btn btn-primary btn-height"> <i class="fa fa-image"></i> Choose </a> </span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label>Content</label>
                            <div class="input-group">
                                <textarea class="form-control" id="caption" name="caption[]" style="height: auto !important;" rows="5">{{$body->caption}}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-danger removeBtn">-</button>
                    </div>
                </div>
            </div>
            
            @endforeach
            @else
            <div class="row">
                <div class="col-md-10">
                    <div class="form-group">
                        <label>Thumbnail</label>
                        <div class="input-group">
                            <input id="thumbnail" class="form-control" type="text" name="thumbnail[]">
                            <span class="input-group-btn"> <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary "> <i class="fa fa-image"></i> Choose </a> </span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Content</label>
                        <div class="input-group">
                            <textarea class="form-control" id="caption" name="caption[]" style="height: auto !important;" rows="5"></textarea>
                        </div>
                    </div>
                </div>

                <div class="col-md-2 mt-5">
                    <button id="plusBtn" class="btn btn-primary">+</button>
                </div>
            </div>

            <div id="append-content">
                
            </div>
            @endif

            <div id="append-content">
                
            </div>

            <div class="form-group mt-4 mb-0 float-right">
                <button type="submit"  class="btn btn-primary submit">Update</button>
            </div>


            </form>
         </div> <!--col-->

      </div>
        </div>

            </div>
         </div> <!--col-->

      </div>
   </div>
</main>


@endsection




@section('extra_js')
<script src="{{ asset('assets/vendors/parsleyjs/dist/parsley.min.js') }}"></script>
    <script src="{{ asset('vendor/laravel-filemanager/js/lfm.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js" type="text/javascript"
            charset="utf-8"></script>
    <script src="{{ asset('assets/vendors/parsleyjs/dist/parsley.min.js') }}"></script>
    <script src="{{ asset('vendor/laravel-filemanager/js/lfm.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tag-it/2.0/js/tag-it.min.js" type="text/javascript"
            charset="utf-8"></script>

    <script src="//cdn.ckeditor.com/4.6.2/standard/ckeditor.js"></script>
    <script>
        var options = {
            filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
            filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=6eEQ6t5njG6CbhhmQfj9U1vzpp1BalkmsOf0S56O',
            filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
            filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token=6eEQ6t5njG6CbhhmQfj9U1vzpp1BalkmsOf0S56O'
        };
    </script>
    <script src="{{ asset('vendor/laravel-filemanager/js/stand-alone-button.js')}}"></script>

<script>
    $(document).ready(function () {
        $('#lfm').filemanager('image');
        
        $('#thumbnail2').filemanager('image');
        $('#feature_lfm').filemanager('image');
        
        @if(!empty($photobodies))
        @foreach($photobodies as $body)
        $('#lfmEdit{{$body->id}}').filemanager('image');
        @endforeach
        @endif
    });
</script>

<script>

    $(document).ready(function () {
        let DID = 0;
        $("#plusBtn").click(function (ele) {
            ele.preventDefault();
            DID++;
            $("#append-content").append('<div id="containerbox"><div class="row"> <div class="col-md-10 mt-3"><label>Thumbnail</label><div class="form-group"><div class="input-group"><input id="thumbnail' + DID + '" class="form-control" maxlenght="250" type="text" name="thumbnail[]"><span class="input-group-btn"> <a  id="lfm' + DID + '" data-input="thumbnail' + DID + '" data-preview="holder" class="btn btn-primary btn-height"> <i class="fa fa-image"></i> Choose </a> </span></div></div> <label for="caption">Content</label><textarea class="form-control" id="caption" name="caption[]" rows="5"></textarea> </div><div class="col-md-2"><button class="btn btn-danger removeBtn">-</button></div></div></div>')
            $("#lfm" + DID).filemanager('image');
        })

        $(document).on('click', '.removeBtn', function () {
            $(this).closest('#containerbox').remove();
            // alert('om');
        });
    });
</script>   
@endsection
@section('extra_js_old')
<script>

$(document).ready(function () {
   $('#lfm').filemanager('image');
   $('#feature_lfm').filemanager('image');
});
</script>

<script>

 $(document).ready(function () {
     let DID = 0;
    $("#plusBtn").click(function(ele){
    ele.preventDefault();
        DID++;
        $("#append-content").append('<div class="containerbox"><div class="row"> <div class="col-md-10 "><label>Thumbnail</label><div class="form-group"><div class="input-group"><input id="thumbnail'+DID+'" class="form-control" maxlenght="250" type="text" name="thumbnail[]"><span class="input-group-btn"> <a  id="lfm'+DID+'" data-input="thumbnail'+DID+'" data-preview="holder" class="btn btn-primary btn-height"> <i class="fa fa-image"></i> Choose </a> </span></div></div> <label for="caption">Content</label><textarea class="form-control" id="caption" name="caption[]" rows="5"></textarea> </div><div class="col-md-2"><button class="btn btn-danger removeBtn">-</button></div></div></div>')
        $("#lfm"+DID).filemanager('image');
   })
   $(document).on('click', '.removeBtn', function () {
        $(this).closest('.containerbox').remove();
    });
});
</script>


@endsection

