@extends('layouts.backend')
@section('title')
Admin
@endsection

@section('extra_css')

<style type="text/css">
  .toggle-off.btn{
    padding-left: 0px;
  }
</style>
@endsection

@section('extra_js')

@endsection

@section('content')
 
  <div class="container-fluid">
    <div class="row justify-content-center">
      @include('back.parts.message')
      <div class="col-lg-6">
        <div class="card shadow-lg border-0 rounded-lg mt-4 mb-3">
          <div class="card-header"><h4 class=" font-weight-normal my-1">Role Information</h4></div>          
          <div class="card-body">
            <form role="form" method="post" action="{{ route('permission.store') }}" enctype="multipart/form-data">
              @csrf
              <div class="form-group row">
                <label class="col-md-3" for="name">Name <span class="text-danger">*</span></label>
                <div class="col-md-9">
                  <input  class=" form-control" name="name" placeholder="Name" type="text" autocomplete="off" required>
                  <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                </div>  
              </div>

              <div class="card-header">
                <h5 class="mb-0 ">Permissions</h5>
              </div>

              <div class="form-group row mt-2 justify-content-center">
                <div class="col-md-8 ">
                  <div class="row mt-1 mb-1">
                      <label class="col-md-10">Products</label>
                      <input  class="toggle-class col-md-4" type="checkbox" value="1" name="product" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="On" data-off="Off">
                  </div>

                  <div class="row mt-1 mb-1">
                      <label class="col-md-10">Website Setup</label>
                      <input  class="toggle-class col-md-4" type="checkbox" value="1" name="website_setup" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="On" data-off="Off">
                  </div>

                </div>
               
              </div>

          
              <button type="submit" class="float-right btn btn-primary">Save</button>
            </form>
          </div>
        </div>
      </div> <!--col-5-->
    </div>  
  </div>

@endsection
