@extends('layouts.backend')
@section('title')
    Admin | Event
@endsection
@section('content')
    <div class="container-fluid">
        @include('back.parts.message')
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                        <div class="col-md-6">
                            <h6 class="m-0 font-weight-bold text-primary">All Event</h6>
                        </div>
                        <div class="col-md-6">
                            <a href="{{ route('event.create') }}" class="btn btn-primary float-right">Add New</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row ">
                            <div class="col-md-12">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Headline</th>
                                        <th>Price</th>
                                        <th class="text-center">Status</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($events as $index=>$page)
                                        @php $index++ @endphp
                                        <tr>
                                            <td>{{ $index }}</td>
                                            <td>{{ Str::limit($page->headline, 100) }}</td>
                                            <td>{{ $page->price }}</td>
                                                    
                                            <td class="text-center">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input toggle-class-pub"
                                                        id="customSwitch{{$page->id}}"
                                                        data-id="{{$page->id}}" {{ $page->status == 1 ? 'checked':'' }}>
                                                    <label class="custom-control-label" for="customSwitch{{$page->id}}"></label>
                                                </div>
                                            </td>
                                            <td class="col__action__body">
                                                {{--<a title="view" target="_blank" href="{{ event_url($page) }}"
                                                   class="btn btn-success btn-sm">View</a>--}}
                                                <a href="{{ route('event.edit', ['id' => $page->id])}}"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="{{ route('event.destroy', ['id' => $page->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop


@section('extra_js')

    <script>
        $(document).ready(function () {
            $('.toggle-class-pub').change(function () {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).data('id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "{{ route('changeEventStatus') }}",
                    data: {'status': status, 'id': id},
                    success: function (data) {
                        toastr.success(data.success)
                    }
                });
            });
        })
    </script>

@endsection
