@extends('layouts.backend')
@section('title')
    Admin | Banner
@endsection
@section('extra_css')

@endsection

@section('extra_js')


@endsection

@section('content')
<div class="container-fluid">
    @include('back.parts.message')
      <div class="row justify-content-center">
        <div class="col-lg-4">
            <div class="card mb-4">
               <div class="card-body">
                   <form role="form" method="post" action="{{ route('banner.store') }}" enctype="multipart/form-data">
                    {{ csrf_field() }}
                  <div class="form-group">
                     <label class="mb-1">Heading <span class="text-danger"></span></label>
                     <input name="heading" placeholder="Heading" type="text" maxlength="250" class="form-control">
                     <span class="text-danger">{{ $errors->has('heading') ? $errors->first('heading'):''}}</span>
                  </div>
                  <div class="form-group">
                     <label class="mb-1">Description <span class="text-danger"></span></label>
                     <input name="description" placeholder="Description" type="text" maxlength="250" class="form-control">
                     <span class="text-danger">{{ $errors->has('description') ? $errors->first('description'):''}}</span>
                  </div>
                  <div class="form-group">
                     <label class="mb-1">Image <span class="text-danger">*</span></label>
                     <div class="custom-file">
                        <input type="file" class="custom-file-input profile-img-input" id="photo" name="photo" required="required">
                        <label class="custom-file-label" for="customFile">Choose file</label>
                     </div>
                     <span class="text-danger">{{ $errors->has('photo') ? $errors->first('photo'):''}}</span>
                     <div class="pt-1" id="profileLabel" for="photo">
                        <img class="profileImgShow" src="{{ asset('defaults/default3.png')}}">
                     </div>
                  </div>
                  <div class="form-group">
                     <div class="float-right mb-3">
                        <button type="submit" class="float-right btn btn-primary">Create</button>
                     </div>
                  </div>
                </form>
               </div>
            </div>
         </div>
         
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                  <h6 class="m-0 font-weight-bold text-primary">All Banner</h6>
                </div>
                <div class="table-responsive">
                    <table class="table align-items-center table-flush">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>Heading</th>
                            <th>Description</th>
                            <th>Photo</th>
                            <th class="text-center " style="width: 150px">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach(\App\Models\Banner::orderBy('id','asc')->get() as $row)
                            <tr>
                                <td>{{$row->id}}</td>
                                <td>{{$row->heading}}</td>
                                <td>{{$row->description}}</td>
                                <td><img src="{{ asset('/img/banner/'.$row->photo) }}" width="80px"></td>
                                <td class="text-center col__action__body">
                                    <a href="{{ route('banner.edit', ['id' => $row->id])}}"
                                       class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i
                                                class="fa fa-edit"></i></a>
                                    <a href="{{ route('banner.delete', ['id' => $row->id])}}"
                                       onclick="return confirm('Are you sure to delete this!')"
                                       class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i
                                                class="fa fa-trash"></i> </a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>  
         </div>
    </div>
</div>
@endsection
