@extends('layouts.backend')
@section('title')
    Admin | Ads update
@endsection

@section('extra_css')

@endsection

@section('extra_js')

@endsection

@section('content')
   
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">Edit Advertisement</h6>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post" action="{{ route('ad.update',['id'=>$ad->id]) }}"
                                  enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                        <input class=" form-control" name="name" value="{{$ad->name}}"
                                               placeholder="Name" type="text" autocomplete="off" required>
                                        <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="url">URL <span class="text-danger"></span></label>
                                        <input class=" form-control" name="url" value="{{$ad->url}}" placeholder="URL"
                                               type="text">
                                        <span class="text-danger">{{ $errors->has('url') ? $errors->first('url'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="position">Position <span
                                                class="text-danger"></span></label>
                                        <input class=" form-control" name="position" value="{{$ad->position}}"
                                               placeholder="Position" type="number">
                                        <span class="text-danger">{{ $errors->has('position') ? $errors->first('position'):''}}</span>
                                </div>
                                <div class="form-group">
                                     <label class="mb-1">Photo <span class="text-danger">*</span></label>
                                     <div class="custom-file">
                                        <input type="file" class="custom-file-input profile-img-input"  id="photo" name="photo">
                                        <label class="custom-file-label" for="customFile">Choose file</label>
                                     </div>
                                     <span class="text-danger">{{ $errors->has('photo') ? $errors->first('photo'):''}}</span>
                                     <div class="pt-1" id="profileLabel" for="photo">
                                        <img class="profileImgShow" src="{{$ad->photo ?asset('ads/'.$ad->photo) : asset('defaults/default3.png')}}">
                                     </div>
                                </div>
                                <button type="submit" class="float-right btn btn-primary ">Update</button>
                                <a href="{{ route('ad.index') }}" class="float-right btn btn-danger mr-2">Cancel</a>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Advertisement</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Name</th>
                                        <th>URL</th>
                                        <th class="text-center col__pos">Position</th>
                                        <th>Photo</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach(\App\Models\Ad::orderBy('position','asc')->get() as $row)
                                        <tr>
                                            <td class="text-center">{{$row->id}}</td>
                                            <td>{{$row->name}}</td>
                                            <td>{{$row->url}}</td>
                                            <td class="text-center">{{$row->position}}</td>
                                            <td><img src="{{ asset('/ads/'.$row->photo) }}" width="80px"></td>
                                            <td class="col__action__body">
                                                <a href="{{ route('ad.edit', ['id' => $row->id])}}"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="{{ route('ad.delete', ['id' => $row->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div> <!--col-6-->
            </div>
        </div>
    
@endsection
