<?php
function bootstrap_load_theme_styles(){
wp_enqueue_style('bootstrap-min-css',get_template_directory_uri().'/css/bootstrap.css', array(), '1.0.0', 'all');  
wp_enqueue_style('fontawesome-min-css',get_template_directory_uri().'/fonts/css/font-awesome.css', array(), '1.0.0', 'all'); 
wp_enqueue_style('fontstyle-min-css',get_template_directory_uri().'/fonts/font.css', array(), '1.0.0', 'all'); 
wp_enqueue_style('dropdownhover-min-css',get_template_directory_uri().'/css/bootstrap-dropdownhover.css', array(), '1.0.0', 'all'); 
wp_enqueue_style('mainstyle-min-css',get_template_directory_uri().'/css/main.css', array(), '1.0.0', 'all');  
wp_enqueue_style('animate-min-css','https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css', array(), '3.1.20', 'all'); 
//js
wp_enqueue_script('modernizr-min-js',get_template_directory_uri() . '/js/modernizr-2.6.2.min.js', array('jquery'), '2.6.2', false );
wp_enqueue_script('bootstrap-min-js', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), '1.0.0', true );
wp_enqueue_script('jquery-min-js','//code.jquery.com/jquery-1.11.1.min.js', array('jquery'), '1.12.0', true );
wp_enqueue_script('dropdownhover-min-js', get_template_directory_uri() . '/js/bootstrap-dropdownhover.js', array('jquery'), '1.0.0', true );
wp_enqueue_script('jquery-easing-js', get_template_directory_uri() . '/js/jquery.easing.1.3.js', array('jquery'), '1.0.0', true );
wp_enqueue_script('script-min-js', get_template_directory_uri() . '/js/scripts.js', array('jquery'), '1.0.0', true );
wp_enqueue_script('grid-min-js', get_template_directory_uri() . '/js/grid-gallery.min.js', array('jquery'), '1.0.0', true );
	}
add_action('wp_enqueue_scripts','bootstrap_load_theme_styles');
//Common Function
function office_master_theme_support(){
	add_theme_support('title-tag');
	add_theme_support('post-thumbnails');
	add_image_size('slide-img',1920,1024, true);
	add_image_size('service-img',100,100, true);
	add_image_size('advertisment-img',500,350, true);
	add_image_size('team-img',1920,1080, true);
	add_image_size('client-img',75,75, true);
	}
add_action('after_setup_theme','office_master_theme_support');
//Menu
function register_theme_menus(){
	register_nav_menus(array(
		'primary_menu'=>'Header Menu',
		'secondary_menu'=>'Bottom Menu',
		'third_menu'=>'Graphic Design',
		'fourth_menu'=>'Printing',
		'fifth_menu'=>'Interior Design',
		'six_menu'=>'Branding',
		'seven_menu'=>'Event Management',
		'eight_menu'=>'Client',
		'nine_menu'=>'Graphic Design Two'
	));
	}
	add_action('init','register_theme_menus');

//CMB2 Custom Field
include_once('inc/cmb2-custom-field.php');	
function idea_holiday_custom_post(){
//Slider
	register_post_type('slider',array(
		'labels'=>array(
		'name'=>'Main Slider',
		'menu_name'=>'Slider Menu',
		'all_items'=>'All slider',
		'add_new'=>'Add New Slide',
		'add_new_item'=>'Add new slide item'
	),
		'public'=>true,
		'supports'=>array(
		'title','thumbnail','revisions','page-attributes'
	)
));
//Our Service
	register_post_type('service',array(
		'labels'=>array(
		'name'=>'Service',
		'menu_name'=>'Our Service',
		'all_items'=>'All Service',
		'add_new'=>'Add New Service',
		'add_new_item'=>'Add new service item'
	),
		'public'=>true,
		'supports'=>array(
		'title','thumbnail','editor','revisions','page-attributes'
	)
));	
//Gallery
	register_post_type('gallery',array(
		'labels'=>array(
		'name'=>'Gallery',
		'menu_name'=>'Gallery',
		'all_items'=>'All Gallery',
		'add_new'=>'Add New Gallery',
		'add_new_item'=>'Add new gallery item'
	),
		'public'=>true,
		'supports'=>array(
		'title','thumbnail','revisions','page-attributes'
	)
));	
//Advertisement
	register_post_type('advertisment',array(
		'labels'=>array(
		'name'=>'Main Advertisement',
		'menu_name'=>'Advertisement Menu',
		'all_items'=>'All Advertisement',
		'add_new'=>'Add New Advertisement',
		'add_new_item'=>'Add new advertisment item'
	),
		'public'=>true,
		'supports'=>array(
		'title','thumbnail','revisions','page-attributes'
	)
));	
//Active Menu Item
add_filter('nav_menu_css_class' , 'special_nav_class' , 10 , 2);

function special_nav_class ($classes, $item) {
    if (in_array('current-menu-item', $classes) ){
        $classes[] = 'active ';
    }
    return $classes;
}							
//Clients
	register_post_type('client',array(
		'labels'=>array(
		'name'=>'Main Client',
		'menu_name'=>'Client Menu',
		'all_items'=>'All Client',
		'add_new'=>'Add New Client',
		'add_new_item'=>'Add new client item'
	),
		'public'=>true,
		'supports'=>array(
		'title','thumbnail','revisions','page-attributes'
	)
));	
//Categories
register_taxonomy ('client_category','client',array(
'labels'=>array(
		'name'=>'Client Category',
		'add_new_item'=>'Add new client category'
),
'hierarchical'=> true,
'show_admin_column'=>true
));			
//
//
function _remove_script_version( $src ){ 
$parts = explode( '?', $src ); 	
return $parts[0]; 
} 
add_filter( 'script_loader_src', '_remove_script_version', 15, 1 ); 
add_filter( 'style_loader_src', '_remove_script_version', 15, 1 );
}
add_action ('init','idea_holiday_custom_post');