<?php

namespace App\Providers;


use App\Services\Sms\Providers\MuthobartaSmsProvider;
use App\Services\Sms\Providers\SolversSmsProvider;
use App\Services\Sms\SmsService;
use App\Models\Menu;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(SmsService::class, function () {
            return new SmsService(new MuthobartaSmsProvider(), new SolversSmsProvider());
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        view()->composer('*', function ($view) {
            $view->with('menus', Menu::with('subMenu')->orderBy('position', 'asc')->get());
        });
    }
}
