<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Category;
use App\Models\SubCategory;
use App\Models\Draft;
use App\Models\Post;
use App\Models\Tag;
use App\Models\LeadPost;

use DateTime;
use Auth;
use Image;
use File;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class WriterController extends Controller
{
    public function posts(){
        $posts = Post::where('user_id',Auth::user()->id)->orderby('id','desc')->Paginate(20);
        return view('back.writer.posts', compact('posts'));
    }

    public function post_create(){   
        $tags = Tag::pluck('name')->toArray();
        $categories = Category::orderBy('position','asc')->get();
        return view('back.writer.post_create', compact('tags','categories'));
    }
    
    public function post_store(Request $request){   
        $request->validate([
            'headline' => 'required',
            'content' => 'required',
            'category_id' => 'required',
        ]);
        $date_time = date('YmdHis');

        if($request->btn_action == 'draft'){
            $post = new Draft;
            $post->user_id = Auth::user()->id;
            $post->headline = $request->headline;
            $post->intro = $request->intro;
            $post->slug = make_slug($request->headline);
            $post->content = $request->content;
            
            if($request->hasfile('image')){
                $file = $request->file('image');
                $fileName = $file->getClientOriginalName();
                $fileExt = $file->getClientOriginalExtension();
                $fileName = $date_time.'.'.$fileExt;
                $f_image = '/blog/'.$fileName;
                $image_resize = Image::make($file->getRealPath());       
                $image_resize->resize(700, 450);
                $image_resize->save(public_path('/blog/' .$fileName));
                $post->image = $f_image;
            }
            $post->status = $request->status;
            $post->sub_cat_id = $request->sub_category_id;
            $post->save();
            if($request->category_id) {
                $post->category()->attach($request->category_id);
            }
            $tag_list = [];
            if ($request->tag_list) {
                $tags = explode(',', $request->tag_list);
                foreach ($tags as $tag) {
                    $slug = make_slug($tag);
                    if ($item = Tag::where('name', $tag)->first()) {
                        array_push($tag_list, $item->id);
                    }else{
                        $item = Tag::firstOrCreate(['name'=>$tag, 'slug'=> $slug]);
                        array_push($tag_list, $item->id);
                    }
                }
            }
            $post->tag()->syncWithoutDetaching($tag_list);

            Session::flash('success', 'Successfully drafted');
            return Redirect::route('writer.draft.index');
        }

        if($request->btn_action == 'create'){
            $post = new Post;
            $post->user_id = Auth::user()->id;
            $post->sticky = $request->sticky ? 1 : 0;
            $post->headline = $request->headline;
            $post->intro = $request->intro;
            $post->slug = make_slug($request->headline);
            $post->content = $request->content;
     
            if($request->hasfile('image')){
            
                $file = $request->file('image');
                $fileName = $file->getClientOriginalName();
                $fileExt = $file->getClientOriginalExtension();
                $fileName = $date_time.'.'.$fileExt;
                // $img = Image::make($file->getRealPath());
                // $img->crop($request->w, $request->h, $request->x1, $request->y1);
                // $img->save(public_path('/profile/' .$fileName));
                $f_image = '/blog/'.$fileName;
                $image_resize = Image::make($file->getRealPath());       
                $image_resize->resize(700, 450);
                $image_resize->save(public_path('/blog/' .$fileName));
                $post->image = $f_image;
            }
            $post->status = $request->status;
            $post->save();
            if ($request->category_id) {
                $post->Category()->attach($request->category_id);
            }
            $tag_list = [];
            if ($request->tag_list) {
                $tags = explode(',', $request->tag_list);
                foreach ($tags as $tag) {
                    $slug = make_slug($tag);
                    if ($item = Tag::where('name', $tag)->first()) {
                        array_push($tag_list, $item->id);
                    }else{
                        $item = Tag::firstOrCreate(['name'=>$tag, 'slug'=> $slug]);
                        array_push($tag_list, $item->id);
                    }
                }
            }
            $post->tag()->syncWithoutDetaching($tag_list);

            $lead_post_position = LeadPost::where('position', $request->sticky_position)->first();
            $lead_post_item = LeadPost::where('post_id', $post->id)->first();
            if ($request->sticky) {
                if ($lead_post_item) {
                    $lead_post_item->delete();
                }
                if ($lead_post_position) {
                    $leadposts = LeadPost::orderBy('position', 'asc')->get();
                    foreach ($leadposts as $leadpost) {
                        if ($leadpost->position == $lead_post_position->position || $leadpost->position > $lead_post_position->position) {
                            $leadpost->position = $leadpost->position + 1;
                            $leadpost->save();
                        }
                    }
                }
            } else {
                if ($lead_post_item) {
                    $lead_post_item->delete();
                }
            }
            if (!empty($request->sticky_position)) {
                $lead_post = new LeadPost();
                $lead_post->position = $request->sticky_position;
                $lead_post->post_id = $post->id;
                $lead_post->save();
            }

            Session::flash('success', 'Successfully Created');
            return Redirect::route('writer.post.index');
        }

        
    }

    public function post_edit($id)
    {
        $post = Post::find($id);
        if(Auth::user()->id ===$post->user_id){
            $categories = Category::orderBy('position','asc')->get();
            $tags = Tag::pluck('name')->toArray();
            return view('back.writer.post_edit', compact('post', 'categories','tags'));
        }

        Session::flash('danger', 'Something wrong');
        return Redirect()->route('writer.post.index');
    }

    public function post_update(Request $request, $id)
    {
        $request->validate([
            'headline' => 'required',
            'content' => 'required',
            'category_id' => 'required'
        ]);
        $post = Post::find($id);

        if(Auth::user()->id === $post->user_id){
            $lead_post_position = LeadPost::where('position', $request->sticky_position)->first();
            $lead_post_item = LeadPost::where('post_id', $post->id)->first();
            if ($request->sticky) {
                if ($lead_post_item) {
                    $lead_post_item->delete();
                }
                if ($lead_post_position) {
                    $leadposts = LeadPost::orderBy('position', 'asc')->get();
                    foreach ($leadposts as $leadpost) {
                        if ($leadpost->position == $lead_post_position->position || $leadpost->position > $lead_post_position->position) {
                            $leadpost->position = $leadpost->position + 1;
                            $leadpost->save();
                        }
                    }
                }
            } else {
                if ($lead_post_item) {
                    $lead_post_item->delete();
                }
            }
            if (!empty($request->sticky_position)) {
                $lead_post = new LeadPost();
                $lead_post->position = $request->sticky_position;
                $lead_post->post_id = $post->id;
                $lead_post->save();
            }
            $post->sticky = $request->sticky ? 1 : 0;
            $post->user_id = Auth::user()->id;
            $post->headline = $request->headline;
            $post->slug = make_slug($request->headline);
            $post->content = $request->content;
            
            $date_time = date('YmdHis');
            if($request->hasfile('image')){
                $file = $request->file('image');
                $fileName = $file->getClientOriginalName();
                $fileExt = $file->getClientOriginalExtension();
                $fileName = $date_time.'.'.$fileExt;
                $f_image = '/blog/'.$fileName;
                $image_resize = Image::make($file->getRealPath());       
                $image_resize->resize(700, 450);
                $image_resize->save(public_path('/blog/' .$fileName));
                $post->image = $f_image;
            }
            $post->status = $request->status;
            $post->Category()->detach();
            $post->tag()->detach();
            $post->save();
            if($request->category_id) {
                $post->Category()->sync($request->category_id);
            }
            $tag_list = [];
            if ($request->tag_list) {
                $tags = explode(',', $request->tag_list);
                foreach ($tags as $tag) {
                    $slug = make_slug($tag);
                    if ($item = Tag::where('name', $tag)->first()) {
                        array_push($tag_list, $item->id);
                    }else{
                        $item = Tag::firstOrCreate(['name'=>$tag, 'slug'=> $slug]);
                        array_push($tag_list, $item->id);
                    }
                }
            }
            $post->tag()->syncWithoutDetaching($tag_list);
            Session::flash('success', 'Successfully Updated');
            return Redirect::to(route('writer.post.index'));
        }
        Session::flash('danger', 'Something wrong');
        return Redirect()->route('writer.post.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Post  $post
     * @return \Illuminate\Http\Response
     */
    public function post_destroy($id)
    {
        $post = Post::find($id);
        if(Auth::user()->id === $post->user_id){
            DB::table('trashposts')->insert(
                ['user_id' => $post->user_id,'deleted_by' => Auth::user()->id,'headline' => $post->headline,'slug' => $post->slug,'intro' => $post->intro,'content' => $post->content,'image' => $post->image,'sticky' => $post->sticky,'status' => $post->status,'view_count' => $post->view_count,'created_at' => $post->created_at,'updated_at' => $post->updated_at]
            );
            $post->tag()->detach();
            $post->category()->detach();
            $post->subCategory()->detach();
            $lead_post_item = LeadPost::where('post_id', $post->id)->first();
            if ($lead_post_item) {
                $lead_post_item->delete();
            }
            $post->delete();
            Session::flash('success', 'Successfully Deleted');
            return Redirect::back();
        }
        Session::flash('danger', 'Something wrong');
        return Redirect()->route('writer.post.index');
    }

    public function draft_index()
    {
        $draft = Draft::where('user_id',Auth::user()->id)->orderby('id','desc')->Paginate(20);
        return view('back.writer.draft_index', compact('draft'));
    }

    public function draft_edit($draft)
    {
        $post = Draft::find($draft);
        if(Auth::user()->id === $post->user_id){
            $post = Draft::find($draft);
            $categories = Category::orderBy('position','asc')->get();
            $tags = Tag::pluck('name')->toArray();
            return view('back.writer.draft_edit', compact('post', 'categories','tags'));
        }
        Session::flash('danger', 'Something wrong');
        return Redirect()->route('writer.post.index');
    }

    public function draft_store(Request $request, $id)
    {
        $request->validate([
            'headline' => 'required',
            'content' => 'required',
            'category_id' => 'required'
        ]);
        $draft = Draft::find($id);

        if(Auth::user()->id === $draft->user_id){
            if(!empty($draft)){
                $draft = Draft::find($id);
                $draft->category()->detach();
                $draft->Tag()->detach();
                $draft->delete();
            }
            $post = new Post;
            $post->user_id = Auth::user()->id;
            $post->headline = $request->headline;
            $post->intro = $request->intro;
            $post->slug = make_slug($request->headline);
            $post->content = $request->content;
            $date_time = date('YmdHis');
            if($request->hasfile('image')){
                $file = $request->file('image');
                $fileName = $file->getClientOriginalName();
                $fileExt = $file->getClientOriginalExtension();
                $fileName = $date_time.'.'.$fileExt;
                $f_image = '/blog/'.$fileName;
                $image_resize = Image::make($file->getRealPath());       
                $image_resize->resize(700, 450);
                $image_resize->save(public_path('/blog/' .$fileName));
                $post->image = $f_image;
            }
            $post->status = $request->status;
            $unicode = md5(uniqid(rand(), true));
            $unicode = substr($unicode,2,6);
            $lastPost=Post::orderBy('id','desc')->first();
            $id = $lastPost->id+1;
            $unicode = $unicode.$id;
            $post->unicode = $unicode;
            $post->save();
            if ($request->category_id) {
                $post->Category()->attach($request->category_id);
            }
            $tag_list = [];
            if ($request->tag_list) {
                $tags = explode(',', $request->tag_list);
                foreach ($tags as $tag) {
                    $slug = make_slug($tag);
                    if ($item = Tag::where('name', $tag)->first()) {
                        array_push($tag_list, $item->id);
                    }else{
                        $item = Tag::firstOrCreate(['name'=>$tag, 'slug'=> $slug]);
                        array_push($tag_list, $item->id);
                    }
                }
            }
            $post->tag()->syncWithoutDetaching($tag_list);

            $lead_post_position = LeadPost::where('position', $request->sticky_position)->first();
            $lead_post_item = LeadPost::where('post_id', $post->id)->first();
            if ($request->sticky) {
                if ($lead_post_item) {
                    $lead_post_item->delete();
                }
                if ($lead_post_position) {
                    $leadposts = LeadPost::orderBy('position', 'asc')->get();
                    foreach ($leadposts as $leadpost) {
                        if ($leadpost->position == $lead_post_position->position || $leadpost->position > $lead_post_position->position) {
                            $leadpost->position = $leadpost->position + 1;
                            $leadpost->save();
                        }
                    }
                }
            } else {
                if ($lead_post_item) {
                    $lead_post_item->delete();
                }
            }
            if (!empty($request->sticky_position)) {
                $lead_post = new LeadPost();
                $lead_post->position = $request->sticky_position;
                $lead_post->post_id = $post->id;
                $lead_post->save();
            }
            Session::flash('success', 'Successfully Created');
            return Redirect::route('writer.post.index');
        }
        Session::flash('danger', 'Something wrong');
        return Redirect()->route('writer.post.index');    
        
    }

    public function draft_destroy( $id)
    {
        $post = Draft::find($id);
            if(Auth::user()->id === $post->user_id){
            $post->category()->detach();
            $post->Tag()->detach();
            $post->delete();
            Session::flash('success', 'Successfully Deleted');
            return Redirect::back();
        }
        Session::flash('danger', 'Something wrong');
        return Redirect()->route('writer.draft.index');
    }
}
