<?php

namespace App\Http\Controllers;


use Image;
use Mail; 
use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\GeneralSetting;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;

class UserController extends Controller
{
    protected function index(){
      return view('back.user.user_index');
    }
    protected function authorList(){
      return view('back.user.authorList');
    }
    
    protected function authorListSearch(Request $request){
        $query = $request->search;
        $users = User::where('name', 'LIKE', '%' . $query . '%')
                ->orWhere('email', 'LIKE', '%' . $query . '%')
                ->paginate(30);
        $users->appends($request->all());
        return view('back.user.authorListSearch', compact('users', 'query'));
    }
    
    
    
    protected function create(){
      return view('back.user.user_create');
    }
    protected function store(Request $request){
        $request->validate([
            'name' => 'required|max:50',
            'email' => 'required|email|unique:users',
            'role' => 'required',
            'password' => 'required|min:8',
            'confirm_password' => 'required|same:password|min:8',
        ]);
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role = $request->role;
        $user->status = 1;
        $user->password = Hash::make($request->password);
        // if($request->hasfile('photo')){
        //     $file = $request->file('photo');
        //     $fileName = $file->getClientOriginalName();
        //     // $img = Image::make($file->getRealPath());
        //     // $img->crop($request->w, $request->h, $request->x1, $request->y1);
        //     // $img->save(public_path('/profile/' .$fileName));
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(200, 200);
        //     $image_resize->save(public_path('/profile/' .$fileName));
        //     $user->photo = $fileName;
        // }
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $file->move(public_path('/profile/'), $fileName);
            $user->photo = $fileName;
        }
        $user->save();
        return Redirect()->back()->with('success',  'User inserted successfully');
    }

    protected function edit($id){
      $user = User::find($id);
            return view('back.user.user_edit', compact('user'));
    }


    protected function update(Request $request, $id){
      $user = User::find($id);
        $request->validate([
            'name' => 'required|max:50',
            'email' => 'required|email|unique:users,email,'.$user->id.',id',
            'role' => 'required',
            'password' => 'required|min:8',
            'confirm_password' => 'required|same:password|min:8',
        ]);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role = $request->role;
        $user->status = 1;
        $user->password = Hash::make($request->password);
        // if($request->hasfile('photo')){
        //     $file = $request->file('photo');
        //     $fileName = $file->getClientOriginalName();
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(200, 200);
        //     $image_resize->save(public_path('/profile/' .$fileName));
        //     $user->photo = $fileName;
        // }
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $file->move(public_path('/profile/'), $fileName);
            $user->photo = $fileName;
        }
        $user->save();
        return Redirect()->route('user.index')->with('success',  'User updated successfully');
    }

    protected function destroy($id){
      $user = User::find($id);
        return Redirect()->route('user.index')->with('success',  'User deleted successfully');
    }

    //profile function
    protected function profile_index(){
      return view('back.user.profile_index');
    }

    protected function profile_edit($id){
      $user = User::find($id);
      return view('back.user.profile_edit', compact('user'));
    }

    protected function profile_update(Request $request, $id){
        $user = User::find($id);
        $request->validate([
            'name' => 'required|max:50',
        ]);
        $user->name = $request->name;
        $user->email = $request->email;
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $image_resize = Image::make($file->getRealPath());       
            $image_resize->resize(100, 100);
            $image_resize->save(public_path('/profile/' .$fileName));
            $user->photo = $fileName;
        }
        // if($request->hasfile('photo')){
        //     $file = $request->file('photo');
        //     $fileName = $file->getClientOriginalName();
        //     $file->move(public_path('/profile/'), $fileName);
        //     $user->photo = $fileName;
        // }
        $user->save();
        return Redirect()->route('user.profile.index')->with('success','Profile updated successfully');
    }
    
    
    
    protected function password_edit(){
        $user = Auth::user();
        if(!empty($user)){
            return view('back.user.password_edit', compact('user'));
        }
      return null;
    }
    
    protected function password_update(Request $request){
        $user = Auth::user();
        $request->validate([
            'current_password' => 'required',
            'password' => 'required|min:8',
            'confirm_password' => 'required|same:password|min:8',
        ]);    
        if (Hash::check($request->current_password, auth()->user()->password) == true) {
            $user->password = Hash::make($request->password);
            $user->save();
            return Redirect()->route('user.password.edit')->with('success',  'Password updated successfully');
        } else {
            Session::flash('current_pass', 'Current password does not match');
            return Redirect()->back();
        }
    }

    //admin
    protected function admin_index(){
        $admins = User::all();
        return view('back.user.admin.admin_index', compact('admins'));
    }

    protected function admin_create(){
        return view('back.user.admin.admin_create');
    }

    protected function admin_store(Request $request){
        $request->validate([
            'name' => 'required|max:50',
            'email' => 'required|email|unique:users',
            'role' => 'required',
            'password' => 'required|min:8',
            'confirm_password' => 'required|same:password|min:8',
        ]);
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->status = 1;
        $user->role = $request->role;
        $user->password = Hash::make($request->password);
        // if($request->hasfile('photo')){
        //     $file = $request->file('photo');
        //     $fileName = $file->getClientOriginalName();
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(200, 200);
        //     $image_resize->save(public_path('/profile/' .$fileName));
        //     $user->photo = $fileName;
        // }
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $file->move(public_path('/profile/'), $fileName);
            $user->photo = $fileName;
        }
        $user->save();
        return Redirect()->route('admin.index')->with('success',  'Admin inserted successfully');
    }

    protected function admin_edit($id){
        $admin = User::find($id);
        return view('back.user.admin.admin_edit', compact('admin'));
    }

    protected function admin_update(Request $request, $id){
        $user = User::find($id);
        $request->validate([
            'name' => 'required|max:50',
            'email' => 'required|email|unique:users,email,'.$user->id.',id',
            'role' => 'required',
            'password' => 'required|min:8',
            'confirm_password' => 'required|same:password|min:8',
        ]);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->status = 1;
        $user->role = $request->role;
        $user->password = Hash::make($request->password);
        // if($request->hasfile('photo')){
        //     $file = $request->file('photo');
        //     $fileName = $file->getClientOriginalName();
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(200, 200);
        //     $image_resize->save(public_path('/profile/' .$fileName));
        //     $user->photo = $fileName;
        // }
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $file->move(public_path('/profile/'),$fileName);
            $user->photo = $fileName;
        }
        $user->save();
        return Redirect()->route('admin.index')->with('success',  'Admin updated successfully');
    }

    protected function admin_destroy($id){
        $staff = User::find($id);
        return Redirect()->route('admin.index')->with('danger',  "Account don't deleted ");
    }



    //staff
    protected function staff_index(){
        $staffs = User::whereIn('role', ['accountant', 'manager'])->get();
        return view('back.user.staff.staff_index', compact('staffs'));
    }

    protected function staff_create(){
        return view('back.user.staff.staff_create');
    }

    protected function staff_store(Request $request){
        $request->validate([
            'name' => 'required|max:50',
            'email' => 'required|email|unique:users',
            'role' => 'required',
            'password' => 'required|min:8',
            'confirm_password' => 'required|same:password|min:8',
        ]);
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role = $request->role;
        $user->password = Hash::make($request->password);
        // if($request->hasfile('photo')){
        //     $file = $request->file('photo');
        //     $fileName = $file->getClientOriginalName();
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(200, 200);
        //     $image_resize->save(public_path('/profile/' .$fileName));
        //     $user->photo = $fileName;
        // }
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $file->move(public_path('/profile/'), $fileName);
            $user->photo = $fileName;
        }
        $user->save();
        return Redirect()->route('staff.index')->with('success',  'Staff inserted successfully');
    }

    protected function staff_edit($id){
        $staff = User::find($id);
        return view('back.user.staff.staff_edit', compact('staff'));
    }

    protected function staff_update(Request $request, $id){
        $user = User::find($id);

        $request->validate([
            'name' => 'required|max:50',
            'email' => 'required|email|unique:users,email,'.$user->id.',id',
            'role' => 'required',
            'password' => 'required|min:8',
            'confirm_password' => 'required|same:password|min:8',
        ]);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role = $request->role;
        $user->password = Hash::make($request->password);
        // if($request->hasfile('photo')){
        //     $file = $request->file('photo');
        //     $fileName = $file->getClientOriginalName();
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(200, 200);
        //     $image_resize->save(public_path('/profile/' .$fileName));
        //     $user->photo = $fileName;
        // }
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $file->move(public_path('/profile/'), $fileName);
            $user->photo = $fileName;
        }
        $user->save();
        return Redirect()->route('staff.index')->with('success',  'Staff updated successfully');
    }

    protected function staff_destroy($id){
        $staff = User::find($id);
        return Redirect()->route('staff.index')->with('success',  'Staff deleted successfully');
    }

    protected function customer_index(){
        $customers = User::where('role', 'customer')->get();
        return view('back.user.customer.customer_index', compact('customers'));
    }

    protected function customer_edit($id){
        $customer = User::find($id);
        return view('back.user.customer.customer_edit', compact('customer'));
    }

    protected function customer_update(Request $request, $id){
        $user = User::find($id);
        $request->validate([
            'name' => 'required|max:50',
            'email' => 'required|unique:users,email,'.$user->id.',id',
            'password' => 'required|min:8',
            'confirm_password' => 'required|same:password|min:8',
        ]);

        $user->name = $request->name;
        $user->email = $request->mobile_no;
        $user->phone = $request->mobile_no;
        $user->password = Hash::make($request->password);

        // if($request->hasfile('photo')){
        //     $file = $request->file('photo');
        //     $fileName = $file->getClientOriginalName();
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(200, 200);
        //     $image_resize->save(public_path('/profile/' .$fileName));
        //     $user->photo = $fileName;
        // }

        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $file->move(public_path('/profile/'), $fileName);
            $user->photo = $fileName;
        }
        $user->save();
        return Redirect()->route('customer.index')->with('success',  'Customer updated successfully');
    }

     
    protected function customer_destroy($id){
        $customer = User::find($id);
        return Redirect()->route('customer.index')->with('success',  'Customer deleted successfully');
    }

    // status toggle button 
    public function changeUserStatus(Request $request){   
        $user = User::find($request->id);
        $user->status = $request->status;
        $user->save();
        return response()->json(['success'=>'Status successfully Changed.']);
    }



    protected function account_register(){
        return view('auth.account.register'); 
    }

    public function registerStore(Request $request){
        $setting = GeneralSetting::orderby('id','desc')->first();
        $request->validate([
            'name' => 'required|min:1|max:32',
            'email' => 'required|email|unique:users',
            'password' => 'min:8',
            'password_confirmation' => 'required_with:password|same:password|min:8'
        ]);
        $code = rand(111111,999999);
       $email = $request->email;
       $token = Str::random(64);
       $data = ['title'=>"Account successfully created",'code'=>$code];
        $user['to'] = $email ;
        Mail::send('mail.mail',$data,function($messages) use ($user){
            $messages->to($user['to']);
            $messages->subject('Verify Code');
        });

        $user = new User();
        $user->name = $request->name;
        $user->email = $email;
        $user->password = Hash::make($request->password);
        $user->code = $code;
        $user->role = 'writer';

        $user->save();
        
        return Redirect('verify');
    }

    public function getVerify(){
        return view('back.user.phone.verify');
    }

    public function postVerify(Request $request){
        $code = $request->code;
        $check = User::where('code', $code)->first();
        if(!empty($check)){
            $check->code = null;
            $check->status = 1;
            $check->save();
            Auth::logout();
            return Redirect()->route('login');
        }else{
            return Redirect()->back()->with('danger','Verify code is wrong');
        }
    }
    
    public function onlineUser(){
          $users = User::select("*")
                        ->whereNotNull('last_seen')
                        ->orderBy('last_seen', 'DESC')
                        ->paginate(10);
        return view('back.user.onlineUser', compact('users'));
    }
    
  



    
}
