<?php

namespace App\Http\Controllers;
use App\Models\Division;
use App\Models\District;
use App\Models\Upazila;
use Illuminate\Http\Request;

use App\Http\Requests;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class UpazilaController extends Controller
{

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $districts = District::orderBy('slug','asc')->get();
        $upazila = Upazila::orderBy('district_id','asc')->Paginate(2000);
        return view('back.upazila.create', compact('districts','upazila'));
    }
    public function create()
    {
        $districts = District::orderBy('slug','asc')->get();
        $upazila = Upazila::orderBy('district_id','asc')->Paginate(2000);
        return view('back.upazila.create', compact('districts','upazila'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'name' => 'required|max:100',
            'district_id' => 'required',
        ]);

        if ($validator->fails()) {
            if (request()->ajax()) {
                return Response::json($validator);
            }
            return Redirect::back()->withErrors($validator);
        }

        if ($request->slug) {
            $slug = $request->slug;
            $slug = strtolower($slug);
        } else {
            $slug = str_replace(' ', '-', $request->name);
            $slug = strtolower($slug);
        }

        $district = new Upazila;
        $district->district_id = $request->district_id;
        $district->name = $request->name;
        $district->slug = $slug;
        $district->save();
        Session::flash('message', 'Successfully Added');

        return Redirect::to(route('upazila.create'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $edit = Upazila::find($id);
        $districts = District::orderBy('slug','asc')->get();
        $upazila = Upazila::orderBy('district_id','asc')->Paginate(2000);
        return view('back.upazila.edit', compact('edit','districts','upazila'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:100',
            'district_id' => 'required',
        ]);

        if ($validator->fails()) {
            if (request()->ajax()) {
                return Response::json($validator);
            }

            return Redirect::back()->withErrors($validator);
        }

        if ($request->slug) {
            $slug = $request->slug;
            $slug = strtolower($slug);
        } else {
            $slug = str_replace(' ', '-', $request->name);
            $slug = strtolower($slug);
        }

        $district = Upazila::find($id);
        $district->district_id = $request->district_id;
        $district->name = $request->name;
        $district->slug = $slug;
        $district->save();
        Session::flash('message', 'Successfully Updated');

        return Redirect::to(route('upazila.create'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $upazila = Upazila::find($id);

        if(!empty($upazila)) {
            $upazila->delete();
            Session::flash('success', 'Successfully Deleted');
        }else{
            Session::flash('danger', 'don\'t Deleted. This record related another records');
        }
        
        return Redirect::to(route('upazila.create'));

    }
}
