<?php

namespace App\Http\Controllers;

use App\Models\Menu;
use App\Models\SubMenu;

use DateTime;
use Auth;
use Image;

use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class SubMenuController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $menus = Menu::orderby('position','asc')->get();
        return view('back.sub_menu.submenu_create', compact('menus'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'menu_id' => 'required',
            'name' => 'required|max:250',
            'url' => 'required|max:250',
        ]);

        $menu = new SubMenu();
        $menu->user_id  = Auth::user()->id;
        $menu->menu_id = $request->menu_id;
        $menu->name = $request->name;
        $menu->url = $request->url;

        if($request->position == null){
            $id = Menu::orderby('id','desc')->first();
            $menu->position = $id->position+1;
        }else{
            $menu->position = $request->position;
        }
        $menu->save();
        return Redirect()->back()->with('success',  'Sub Menu inserted successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\SubMenu  $subMenu
     * @return \Illuminate\Http\Response
     */
    public function show(SubMenu $subMenu)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\SubMenu  $subMenu
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        $menus = Menu::orderby('position','asc')->get();
        $submenu = SubMenu::find($id);
        return view('back.sub_menu.submenu_edit', compact('menus', 'submenu'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\SubMenu  $subMenu
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'menu_id' => 'required',
            'name' => 'required|max:250',
            'url' => 'required|max:250',
        ]);
        
        $sub_menu = SubMenu::find($id);
        
        $sub_menu->user_id  = Auth::user()->id;
        $sub_menu->menu_id = $request->menu_id;
        $sub_menu->name = $request->name;
        $sub_menu->url = $request->url;

        if($request->position == null){
            $id = Menu::orderby('id','desc')->first();
            $sub_menu->position = $id->position+1;
        }else{
            $sub_menu->position = $request->position;
        }
        $sub_menu->save();
        return Redirect()->route('submenu.index')->with('success',  'Sub Menu updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\SubMenu  $subMenu
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $sub_menu = SubMenu::find($id);
        $sub_menu->delete();
        Session::flash('success', 'Sub Menu deleted successfully');
        
        return Redirect()->back();
    }
}
