<?php

namespace App\Http\Controllers;

use App\Models\Service;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $items = Service::orderby('position','asc')->get();
        return view('back.service.index', compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        return view('back.service.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'short_intro' => 'required|max:250',
            'details' => 'required',
            'position' => 'required',
        ]);
        $item = new Service();
        $item->upcoming = $request->upcoming ? 1 :0;
        $item->short_intro = $request->short_intro;
        $item->slug = make_slug($request->short_intro);
        $item->url = $request->url;
        $item->details = $request->details;
        $item->position = $request->position;
        if($request->hasfile('image')){
            $file = $request->file('image');
            $fileName = time().'.'.$file->getClientOriginalExtension();
             $file->move(public_path('/img/service/'), $fileName);
            $item->image = $fileName;
        }
        if($request->hasfile('icon')){
            $file = $request->file('icon');
            $fileName = time().'.'.$file->getClientOriginalExtension();
             $file->move(public_path('/img/service/'), $fileName);
            $item->icon = $fileName;
        }
        $item->save();
        return Redirect()->back()->with('success','inserted successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function show(Service $service)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function edit( $id)
    {
        $item = Service::findOrFail($id);
        return view('back.service.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'short_intro' => 'required|max:250',
            'details' => 'required',
            'position' => 'required',
        ]);
        $item = Service::findOrFail($id);
        $item->upcoming = $request->upcoming ? 1 :0;
        $item->short_intro = $request->short_intro;
        $item->slug = make_slug($request->short_intro);
        $item->url = $request->url;
        $item->details = $request->details;
        $item->position = $request->position;
        if($request->hasfile('image')){
            $file = $request->file('image');
            $fileName = time().'.'.$file->getClientOriginalExtension();
             $file->move(public_path('/img/service/'), $fileName);
            $item->image = $fileName;
        }
        if($request->hasfile('icon')){
            $file = $request->file('icon');
            $fileName = time().'.'.$file->getClientOriginalExtension();
             $file->move(public_path('/img/service/'), $fileName);
            $item->icon = $fileName;
        }
        $item->save();
        return Redirect()->route('service.index')->with('success','Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function destroy( $id)
    {
        $item = Service::findOrFail($id);
        $item->delete();
        return Redirect()->route('service.index')->with('success','Updated successfully');
    }
}
