<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use App\Models\Order;
use App\Models\Search;
use Illuminate\Http\Request;

use DateTime;
use Auth;
use Image;

use Carbon\Carbon;

use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class ReportController extends Controller
{
    public function user_search_report(){
        $search_report = Search::orderby('count','desc')->paginate(50);
        return view('back.reports.user_search_report', compact('search_report'));
    }
    
    public function inventory(){
        $products = Product::orderby('id', 'desc')->paginate(50);
        return view('back.reports.inventory', compact('products'));
    }
    public function inventorySearch(Request $request){
        $query = $request->search;
        $product = Product::where('id', $query)->first();
        if(!empty($product)){
            $products = Product::where('id', $query)->paginate(50);
        }else{
            $products = Product::where('product_name', 'LIKE', '%' . $query . '%')
                ->orWhere('id', 'LIKE' . $query)
                ->paginate(50);
        }
        $products->appends($request->all());
        return view('back.reports.inventorySearch', compact('products','query'));
    }
    
    public function inventorySorting(Request $request){
        $sort = $request->stock;
        if(!empty($sort)){
            $products = Product::orderBy('quantity',$sort)->paginate(50);
        }else{
            $products = Product::orderby('id', 'desc')->paginate(50);
        }
        $products->appends($request->all());
        return view('back.reports.inventorySearch', compact('products','sort'));
    }
    
    
    
    public function salesReport(){
        $orders = Order::where('delivery_status','delivered')->orderBy('id','desc')->paginate(50);
        return view('back.reports.salesReport', compact('orders'));
    }
    public function salesReportSearch(Request $request){
        $query = $request->search;
        $orders = Order::where('product_id', $query)->first();
        if(!empty($orders)){
            $orders = Order::where('product_id', $query)->paginate(50);
        }else{
            $orders = Order::where('product_name', 'LIKE', '%' . $query . '%')
                ->orWhere('id', 'LIKE' . $query)
                ->paginate(50);
        }
        $orders->appends($request->all());
        $grand_total_qty = $orders->sum('product_quantity');
        $grand_total_sale = $orders->sum('total_price');
        $grand_total_discount = $orders->sum('total_discount');

        return view('back.reports.salesReportSearch', compact('orders','query','grand_total_qty','grand_total_sale','grand_total_discount'));
    }
    
    public function salesReportDate(Request $request){
        $daterange = $request->date;
        $query = $request->date;
        $start_date = substr($daterange, 0,-13);
        $start_date = strtotime($start_date);
        $start_date = date("Y-m-d", $start_date);
        $end_date = substr($daterange, -10);
        $end_date = strtotime($end_date);
        $end_date = date("Y-m-d", $end_date);
        $orders = Order::whereBetween('date', [$start_date, $end_date])->orderBy('id','desc')->get();
        $grand_total_qty = $orders->sum('product_quantity');
        $grand_total_sale = $orders->sum('total_price');
        $grand_total_discount = $orders->sum('total_discount');

        return view('back.reports.salesReportDate', compact('orders','start_date','end_date','grand_total_qty','grand_total_sale','grand_total_discount'));
    }
     
}
