<?php

namespace App\Http\Controllers;

use App\Models\PostCategory;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Session;
class PostCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view("back.blog.category.create");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:100',
        ]);

        $category = new PostCategory();

        $category->name = $request->name;
        if($request->slug == null){
            $category->slug = make_slug($request->name);
        }else{
            $category->slug = make_slug($request->slug);
        }
        
        if($request->position == null){
            $id = PostCategory::orderby('id','desc')->first();
            if(!empty($id)){
             $category->position = $id->position+1;
            }else{
                $category->position = 1;
            }
        }else{
            $category->position = $request->position;
        }

        $category->save();
        return Redirect()->back()->with('success',  'inserted successfully');
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PostCategory  $postCategory
     * @return \Illuminate\Http\Response
     */
    public function edit( $id)
    {
        $edit = PostCategory::find($id);
        return view('back.blog.category.edit', compact('edit'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PostCategory  $postCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $category = PostCategory::find($id);
        $request->validate([
            'name' => 'required|max:100',
        ]);

        $category->name = $request->name;
        if($request->slug == null){
            $category->slug = make_slug($request->name);
        }else{
            $category->slug = make_slug($request->slug);
        }
        
        if($request->position == null){
            $id = PostCategory::orderby('id','desc')->first();
            if(!empty($id)){
             $category->position = $id->position+1;
            }else{
                $category->position = 1;
            }
        }else{
            $category->position = $request->position;
        }

        $category->save();
        return Redirect()->route('post.category.create')->with('success',  'updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PostCategory  $postCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy( $id)
    {
        $total_post = PostCategory::find($id)->Posts()->count();
        // dd($total_post);
        if($total_post == 0){
            PostCategory::find($id)->delete();
            Session::flash('message', 'Successfully Deleted the Category');
        } else {
            Session::flash('danger', 'Sorry, You have some posts related with this Category');
        }
        return Redirect()->route('post.category.create');
    }
}
