<?php

namespace App\Http\Controllers;

use App\Models\Member;
use Illuminate\Http\Request;
use DateTime;
use Auth;
use Image;
use Carbon\Carbon;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class MemberController extends Controller
{
    public function index(){
        return view('back.member.index');
    }
    public function create(){
        return view('back.member.create');
    }
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'designation' => 'required',
            'member_type' => 'required',
            'photo' => 'required',
        ]);
        
        $member =  new Member();
        $member->user_id               = Auth::user()->id;
        $member->name          = $request->name;
        $member->designation          = $request->designation;
        $member->member_type          = $request->member_type;
        $member->email          = $request->email;
        $member->mobile_no          = $request->mobile_no;
        $member->position          = $request->position;
        $member->content          = $request->content;
        $member->highlight          = $request->highlight?1:0;
        $date_time = date('YmdHis');
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileName = $date_time.'.'.$fileExt;
            $image_resize = Image::make($file->getRealPath());       
            $image_resize->resize(400, 400);
            $image_resize->save(public_path('/img/member/' .$fileName));
            $member->photo = $fileName;
        }
     
        $member->save();
        return Redirect()->back()->with('success',  'inserted successfully');
    }

    public function edit($id)
    {
        $edit = Member::find($id);
        return view('back.member.edit', compact('edit'));
    }

    public function update(Request $request,  $id)
    {
        $member =  Member::find($id);
        $request->validate([
            'name' => 'required',
            'designation' => 'required',
            'member_type' => 'required',
        ]);
        $member->user_id               = Auth::user()->id;
        $member->name          = $request->name;
        $member->designation          = $request->designation;
        $member->member_type          = $request->member_type;
        $member->email          = $request->email;
        $member->mobile_no          = $request->mobile_no;
        $member->position          = $request->position;
        $member->content          = $request->content;
        $member->highlight          = $request->highlight?1:0;
        $date_time = date('YmdHis');
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileName = $date_time.'.'.$fileExt;
            $image_resize = Image::make($file->getRealPath());       
            $image_resize->resize(400, 400);
            $image_resize->save(public_path('/img/member/' .$fileName));
            $member->photo = $fileName;
        }
        $member->save();
        
        return Redirect()->route('member.index')->with('success',  'update successfully');
    }
    
    public function destroy($id){
        $member =  Member::find($id);
        $member->delete();
        return Redirect()->route('member.index')->with('success',  'Deleted successfully');
    }
    

    
}