<?php

namespace App\Http\Controllers;
use Auth;
use App\Models\Product;
use App\Models\LandingPage;
use App\Models\PageContent;
use App\Models\LandingCol;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class LandingPageController extends Controller
{
    public function index()
    {
        $pages=LandingPage::all();
        return view('back.landing_page.index',compact('pages'));
    }

    public function create()
    {
        $products = Product::orderby('id','desc')->get();
        return view('back.landing_page.create', compact('products'));
    }


    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|max:200',
            'status' => 'required',
            'product_id' => 'required',
        ]);
        $landingPage = new LandingPage;
        $landingPage->title = $request->title;
        $landingPage->product_id = $request->product_id;
        $landingPage->status = $request->status;
        $landingPage->user_id = Auth::user()->id;
        $landingPage->slug = make_slug($request->title);
        $landingPage->save();
        Session::flash('success', 'Successfully Added');
        return Redirect::back();
    }

    public function edit( $id)
    {
        $products = Product::orderby('id','desc')->get();
        $page = LandingPage::find($id);
        return view('back.landing_page.edit',compact('page','products'));
    }
    public function show( $id)
    {
        $page = LandingPage::find($id);
        return view('back.landing_page.show',compact('page'));
    }

    public function update(Request $request,  $id)
    {
        $landingPage = LandingPage::find($id);
        $request->validate([
            'title' => 'required|max:200',
            'status' => 'required',
            'product_id' => 'required',
        ]);

        $landingPage->title = $request->title;
        $landingPage->product_id = $request->product_id;
        $landingPage->status = $request->status;
        $landingPage->user_id = Auth::user()->id;
        $landingPage->slug = make_slug($request->title);
        $landingPage->save();
        Session::flash('success', 'Successfully Updated');
        return Redirect::route('landing.page.index');
    }

    public function destroy($id)
    {
        $page = LandingPage::find($id);
        $pageContent = PageContent::where('landing_page_id',$page->id)->get();
        foreach($pageContent as $item){
            $item->delete();
        }
        $page->delete();
        Session::flash('success', 'Successfully Deleted');
        return Redirect::back();
    }

    public function content_create(){
        $pages=LandingPage::all();
        return view('back.landing_page.content.create',compact('pages'));
    }
    public function content_add($id){
        $page = LandingPage::find($id);
        // dd($page);
        return view('back.landing_page.content.content_add',compact('page'));
    }
    public function content_store(Request $request){
        $last = PageContent::orderby('id','desc')->first();
        $request->validate([
            'landing_page_id' => 'required',
            'type' => 'required',
        ]);
        // dd($request);
        $date_time = date('ymdHis');
        $pageContent =new PageContent();
        $pageContent->landing_page_id = $request->landing_page_id;
        $pageContent->type = $request->type;
        $pageContent->article = $request->article;
        $pageContent->image_position = $request->image_position;
        $pageContent->num_of_col = $request->num_of_col;
        $pageContent->position = $last->id+1;
        if($request->hasfile('image')){
            $file = $request->file('image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileName = $date_time.'.'.$fileExt;
            $file->move(public_path('/article/'), $fileName);
            $pageContent->image = $fileName;
        }
        $pageContent->save();
        Session::flash('success', 'Successfully Added');
        return Redirect::back();
    }
    public function all_pages_view($id){
        $page = LandingPage::find($id);
        $pageContents = PageContent::where('landing_page_id',$page->id)->orderby('position','asc')->get();
        return view('back.landing_page.all_pages_view',compact('page','pageContents'));
    }

    public function updatePosition(Request $request){
       // return $request->position;

        foreach ($request->position as $key => $id){
            $lead_post = PageContent::where([['landing_page_id',$request->id],['id',$id]])->first();
            $lead_post->update(['position' => $key+1]);
        }
        return response()->json(array(
            'success' => true,
        ));
    }

    public function column_add($id){
        $col = PageContent::findOrFail($id);
        // dd($col);
        return view('back.landing_page.column_add',compact('col'));
    }

    public function column_store(Request $request){
        // $request->validate([
        //     'landing_page_id' => 'required',
        //     'type' => 'required',
        // ]);
        // dd($request);
        $date_time = date('ymdHis');
        $col = new LandingCol();
        $col->page_content_id = $request->page_content_id;
        $col->headline = $request->headline;
        $col->description = $request->description;
        if($request->hasfile('image')){
            $file = $request->file('image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileName = $date_time.'.'.$fileExt;
            $file->move(public_path('/article/'), $fileName);
            $col->image = $fileName;
        }
        $col->save();
        Session::flash('success', 'Successfully Added');
        return Redirect::back();
    }
    
}
