<?php

namespace App\Http\Controllers\Front;

use App\Models\Post;
use App\Models\Work;
use App\Models\Client;
use App\Models\Category;
use App\Models\ClientType;
use Illuminate\Http\Request;
use App\Models\ContactMessage;
use App\Http\Controllers\Controller;
use App\Models\WorkType;

class HomeController extends Controller
{
    public function home(){
        return view('front.pages.home');
    }

    public function completed_work(){
        $types = WorkType::all();
        return view('front.pages.completed-work', compact('types'));
    }
    
    public function client(){
         $clients = Client::all();
        return view('front.pages.client', compact('clients'));
    }

     public function services(){
        $types = ClientType::all();
        return view('front.pages.services');
    }
      public function package(){
        $types = ClientType::all();
        return view('front.pages.package');
    }
      public function orderNow(){
        $types = ClientType::all();
        return view('front.pages.order_now');
    }

    public function client_single($slug){

        $types = ClientType::all();
        $type = ClientType::where('slug',$slug)->first();
        
        $clients = Client::where('client_type_id',$type->id)->get();
        return view('front.pages.client_single', compact('types','clients'));
    }

    public function work_single($id, $slug = null)
    {
        $work = Work::Find($id);
        // where('slug', $slug)->first();
        if (! $work) {
            // Option 1: Redirect back with error
            return redirect()->back()->with('error', 'Work type not found.');
        }
        $workItems = Work::where('work_type_id', $work->work_type_id)->select('id', 'name', 'slug')->get();
    
        return view('front.pages.work_single', compact('work', 'workItems'));
    }
    
    
    public function work_single11($slug = null)
    {
        $work_type = WorkType::where('slug', $slug)->first();
        if (! $work_type) {
            // Option 1: Redirect back with error
            return redirect()->back()->with('error', 'Work type not found.');
        }
        $workItems = Work::where('work_type_id', $work_type->id)->pluck('name', 'slug');
        $work = Work::where('slug', $slug)->first();
        dd($work );
        return view('front.pages.work_single', compact('work_type', 'workItems','work'));
    }


    

    public function posts(){
        return view('front.pages.posts');
    }

    public function singlePost($category, $id)
    {
        $post = Post::find($id);
        if($post->status == 1){
            $category = Category::where('slug', $category)->select('id','name')->first();
            if($post != null && $category!= null){
                $post->view_count = $post->view_count + 1;
                $post->save();
                return view('front.pages.single_post', compact('post', 'category'));
            }else{
                return view('errors.my_404');
            }
        }
        return view('errors.my_404');
    }

    public function about(){
        return view('front.pages.about');
    }
    public function contact(){
        return view('front.pages.contact');
    }
    public function return_policy(){
        return view('front.pages.return');
    }
    public function privacy(){
        return view('front.pages.privacy');
    }
    public function terms(){
        return view('front.pages.terms');
    }
    public function team(){
        return view('front.pages.team');
    }
    public function gallery(){
        return view('front.pages.gallery');
    }
    public function plan(){
        return view('front.pages.plan');
    }

    public function message(Request $request){

        $validated = $request->validate([
            'name' => 'required|string|max:30',
            'email' => 'required|string|max:100',
            'message' => 'required|string|max:300',
        ]);
        
        // dd($request->all());
   
        $mess = new ContactMessage();
        $mess->name     = $validated['name'];
        $mess->email     = $validated['email'];
        $mess->message     = $validated['message'];
        $mess->save();
        return Redirect()->back()->with('success',  'The query was successfully sent.');
    }

}
