<?php

namespace App\Http\Controllers;

use App\Models\Event;
use Illuminate\Http\Request;

class EventController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $events = Event::orderBy('id','desc')->get();
        return view('back.event.index',compact('events'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('back.event.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'headline' => 'required|string|max:400',
            'price' => 'required|integer',
        ]);
        // Cast the 'amount' to an integer
        $validated['price'] = intval($validated['price']);
        
        $event = new Event();
        $event->headline = $request->headline;
        $event->price = $validated['price'];
        $event->start = $request->start;
        $event->end = $request->end;
        $event->content = $request->content;
        $event->status = 1;
        $event->save();
        return redirect()->route('event.index')->with('success', 'created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Event $event)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit( $id)
    {
        $event = Event::findOrFail($id);
        return view('back.event.edit',compact('event'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request,  $id)
    {
        $validated = $request->validate([
            'headline' => 'required|string|max:400',
            'price' => 'required|integer',
        ]);
        // Cast the 'amount' to an integer
        $validated['price'] = intval($validated['price']);
        $event = Event::findOrFail($id);
        $event->headline = $request->headline;
        $event->price = $validated['price'];
        $event->start = $request->start;
        $event->end = $request->end;
        $event->content = $request->content;
        $event->save();
        return redirect()->route('event.index')->with('success', 'Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $event = Event::findOrFail($id);
        $event->delete();
        return redirect()->route('event.index')->with('success', 'deleted successfully.');
    }

    public function changeStatus(Request $request){
        $event = Event::find($request->id);
        $event->status = $request->status;
        $event->save();
        return response()->json(['success'=>'Status successfully changed.']);
    }
}
