<?php

namespace App\Http\Controllers;

use App\Models\Color;
use Illuminate\Http\Request;

class ColorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('back.color.color_create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:40',
            'code' => 'max:40',
        ]);

        $color = new Color();
        $color->name = $request->name;
        $color->code = $request->code;
        $color->save();
        return Redirect()->back()->with('success',  'Color inserted successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show( $color)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit( $id)
    {
        $color = Color::find($id);
        return view('back.color.color_edit', compact('color'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $color = Color::find($id);

        $request->validate([
            'name' => 'required|max:40',
            'code' => 'max:40',
        ]);

        $color->name = $request->name;
        $color->code = $request->code;
        $color->save();
        return Redirect()->route('color.create')->with('success',  'Color updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy( $id)
    {
        $color = Color::find($id);
        $color->delete();
        return Redirect()->route('color.create')->with('success',  'Color deleted successfully');
    }
}
