<?php

namespace App\Http\Controllers;

use App\Models\ClientType;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class ClientTypeController extends Controller
{
    public function index()
    {
        $types = ClientType::orderBy('id','asc')->get();
        return view('back.client-type.index', compact('types'));
    }

    public function create()
    {
        $types = ClientType::orderBy('id','desc')->get();
        return view('back.client-type.index', compact('types'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:250',
        ]);
        $item = new ClientType();
        $item->name = $request->name;

        if($request->slug == null){
            $item->slug = Str::slug($request->name);
        }else{
            $item->slug = Str::slug($request->slug);
        }
        $item->save();
        return Redirect()->back()->with('success','inserted successfully');
    }
  
    public function edit( $id)
    {
        $types = ClientType::orderBy('id','asc')->get();
        $item = ClientType::findOrfail($id);
        return view('back.client-type.edit', compact('item','types'));
    }
    
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:250',
        ]);
        $item =  ClientType::findOrfail($id);
        $item->name = $request->name;
        if($request->slug == null){
            $item->slug = Str::slug($request->name);
        }else{
            $item->slug = Str::slug($request->slug);
        }
        $item->save();
        return Redirect()->route('client.type.index')->with('success','updated successfully');
    }

    public function destroy($id)
    {
        $item = ClientType::findOrFail($id);

        if ($item->clients()->count() > 0) {
            return redirect()
                ->route('client.type.index')
                ->with('error', 'This work type cannot be deleted because it has related works.');
        }

        $item->delete();

        return redirect()
            ->route('client.type.index')
            ->with('success', 'Deleted successfully');
    }
   
}
