<?php

namespace App\Http\Controllers;


use App\Models\Banner;
use App\Models\Post;

use DateTime;
use Auth;
use Image;

use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class BannerController extends Controller
{
    public function create()
    {
        return view('back.banner.create');
    }

    public function store(Request $request)
    {   
        $request->validate([
            'heading' => 'required|max:250',
            'description' => 'required|max:250',
            'photo' => 'required',
        ]);
        
        $banner = new Banner;
        $banner->heading = $request->heading;
        $banner->description = $request->description;
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = time().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('/img/banner/'), $fileName);
            $banner->photo = $fileName;
        }
        $banner->save();
        Session::flash('success', 'Successfully Added');
        return Redirect::back();

    }

    public function edit($id)
    {
        $edit = Banner::find($id);
        return view('back.banner.edit', compact('edit'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'heading' => 'required|max:250',
            'description' => 'required|max:250',
        ]);
        
        $banner = Banner::find($id);
        $banner->heading = $request->heading;
        $banner->description = $request->description;
        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = time().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('/img/banner/'), $fileName);
            $banner->photo = $fileName;
        }
        $banner->save();
        Session::flash('success', 'Successfully Updated');
        return Redirect::to(route('banner.create'));
    }

    public function destroy($id)
    {
        Banner::find($id)->delete();
        Session::flash('success', 'Successfully Deleted');
        return Redirect::to(route('banner.index'));
    }
    
    public function banner_status_toggle(Request $request){
        $banner = Banner::find($request->id);
        $banner->status = $request->status;
        $banner->save();
        return response()->json(['success'=>'Banner status change successfully.']);
    }
    
}
